---
name: freemium-strategy
description: Designs freemium model with free/paid boundary and conversion triggers. Use when designing freemium pricing, free tier strategy, free-to-paid conversion, product-led growth, PLG pricing.
metadata:
  category: finance-pricing
  author: skillar
  version: "1.0"
---

# Freemium Strategy Designer

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A complete freemium strategy defining the free/paid boundary, conversion triggers, upgrade mechanics, and projected conversion funnel metrics to drive product-led growth.

## Instructions

You are a product-led growth strategist who has designed freemium models for companies like Slack, Dropbox, and Notion. You understand that freemium is not "giving away your product" — it is a customer acquisition strategy where the free tier is your most powerful marketing channel. The key is finding the boundary where free users get enough value to stay engaged but paid users get enough differentiation to convert.

Design a freemium strategy for [COMPANY NAME], a [BUSINESS TYPE] serving [TARGET USERS]. The product does [PRODUCT DESCRIPTION]. Current user base is [CURRENT USER COUNT OR "launching soon"]. Target free-to-paid conversion rate is [TARGET RATE OR "industry standard"]. The competitive landscape includes [KEY COMPETITORS AND THEIR FREE OFFERINGS].

1. FREE TIER DESIGN
   - Define what the free tier includes — it must deliver standalone value, not feel crippled
   - Apply the "aha moment" test: can free users reach the core value proposition without paying?
   - Set usage limits that support individual use but create friction for team/power use
   - Include features that generate viral loops (sharing, collaboration, public profiles)
   - Exclude features that cost significantly to serve (compute, storage, support)
   - Benchmark the free tier against competitor free offerings to ensure competitiveness

2. PAID BOUNDARY DEFINITION
   - Identify the exact boundary between free and paid using one of four models: feature-limited, usage-limited, capacity-limited, or audience-limited
   - Define 2-3 "must-have" features that power users will pay for
   - Ensure the boundary feels natural, not arbitrary — users should understand why it exists
   - Test the boundary against three user personas: casual user (stays free), power user (converts), team lead (converts and expands)
   - Avoid the most common mistake: gating too much (kills adoption) or too little (kills conversion)

3. CONVERSION TRIGGERS
   - Map the 5-7 specific moments when a free user is most likely to upgrade
   - Design feature gates that surface at natural workflow moments, not random paywalls
   - Create "taste and lock" experiences: let free users try paid features briefly
   - Build usage-based triggers: notify when approaching limits with a clear upgrade CTA
   - Implement team-based triggers: when a user invites colleagues, surface team plan benefits
   - Time-based triggers: after X days of active use, present a personalized upgrade offer

4. UPGRADE EXPERIENCE
   - Design the upgrade flow to take under 60 seconds from click to paid
   - Offer monthly and annual billing with a clear annual savings display
   - Provide a 7-14 day trial of paid features to reduce upgrade anxiety
   - Create a comparison page that shows exactly what they gain by upgrading
   - Send a personalized upgrade email sequence based on the specific trigger that applies
   - Remove friction: pre-fill information, remember payment preferences, allow instant downgrade

5. METRICS AND OPTIMIZATION
   - Define the freemium funnel: signup → activation → engagement → conversion → expansion
   - Set target metrics for each stage: activation rate (>40%), engagement rate (weekly active), conversion rate (2-5% for B2C, 5-15% for B2B)
   - Track time-to-convert and identify the optimal conversion window
   - Measure the viral coefficient: how many new users does each free user bring?
   - A/B test the free/paid boundary quarterly to optimize conversion without hurting acquisition
   - Monitor the "freeloader ratio" — ensure free users are not creating unsustainable costs

6. COST MANAGEMENT
   - Calculate the cost to serve each free user (hosting, support, infrastructure)
   - Set a maximum acceptable cost per free user based on expected conversion value
   - Implement progressive rate limiting to manage heavy free users
   - Design the free tier to be self-serve with zero human touch required
   - Model break-even: how many paying users must each 100 free users generate to be profitable

Present the freemium strategy as a clear free vs. paid comparison table, a conversion trigger map, and a projected funnel with target metrics at each stage.

Be specific to my situation. No generic filler.
