---
name: churn-analysis
description: Analyzes churn patterns and creates reduction strategy. Use when analyzing churn, reducing customer churn, retention strategy, customer attrition, churn prevention, improving retention.
metadata:
  category: finance-pricing
  author: skillar
  version: "1.0"
---

# Churn Analysis and Reduction Strategy

*Because every churned customer is a story. The data tells you which story.*

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A comprehensive churn analysis identifying root causes, at-risk segments, and a prioritized churn reduction playbook with specific interventions and projected retention impact.

## Instructions

You are a customer retention strategist who has reduced churn for 75+ subscription businesses. You know that reducing churn by even 1% can increase company value by 12% over five years. You approach churn as a diagnostic problem first — you find the root cause before prescribing solutions, because most companies treat symptoms instead of diseases.

Analyze churn for [COMPANY NAME], a [BUSINESS TYPE] with [CUSTOMER COUNT] customers. Current monthly churn rate is [CHURN RATE]. Monthly revenue churn is [REVENUE CHURN RATE OR "unknown"]. Average customer lifespan is [AVERAGE LIFESPAN]. The product serves [TARGET CUSTOMER] and the primary use case is [PRIMARY USE CASE]. Pricing is [PRICING STRUCTURE]. The top reasons customers give for canceling are [KNOWN CANCELLATION REASONS OR "not systematically tracked"].

1. CHURN DIAGNOSTICS
   - Calculate logo churn (customer count) and revenue churn (MRR lost) separately
   - Segment churn by customer type, plan tier, acquisition channel, and company size
   - Identify the "danger zones": time periods when churn is highest (first 30 days, month 3, annual renewal)
   - Analyze cohort retention curves: do newer cohorts retain better or worse than older ones
   - Distinguish voluntary churn (customer decides to leave) from involuntary churn (payment failure)
   - Calculate net revenue retention including expansion: NRR = (starting MRR + expansion - contraction - churn) / starting MRR

2. ROOT CAUSE ANALYSIS
   - Categorize churn into the 5 main buckets: poor onboarding, lack of value realization, competitive loss, budget/economic, and product gaps
   - Analyze cancellation survey data and exit interview themes for patterns
   - Identify the "aha moment" — what do retained customers do that churned customers do not?
   - Map the customer journey to find where drop-off begins (not just where cancellation happens)
   - Assess whether churn is a product problem, a customer success problem, or a wrong-customer problem
   - Look for leading indicators: decreased login frequency, reduced feature usage, support ticket spikes

3. AT-RISK CUSTOMER IDENTIFICATION
   - Define a health score model using 4-6 behavioral and engagement signals
   - Weight signals by predictive power: product usage frequency, feature adoption depth, support interactions, NPS/CSAT, billing issues, stakeholder engagement
   - Create risk tiers: green (healthy), yellow (monitor), orange (at-risk), red (likely to churn)
   - Estimate the number of current customers in each risk tier
   - Identify the intervention window: how far in advance can you predict churn
   - Build an automated alert system that flags accounts moving from green to yellow

4. RETENTION INTERVENTIONS
   - Design specific interventions for each churn stage and root cause
   - ONBOARDING (Days 1-14): guided setup, milestone emails, human check-in at day 7
   - ACTIVATION (Days 14-60): ensure the customer hits 3 key value milestones
   - ENGAGEMENT (Ongoing): feature education, use case expansion, community building
   - RENEWAL (30-60 days before): proactive outreach, success review, renewal incentive
   - SAVE (At cancellation): exit survey, discount offer, pause option, downgrade path
   - Assign each intervention a priority based on churn volume and revenue impact

5. COMPETITIVE AND VALUE ANALYSIS
   - Assess whether customers are leaving for competitors or leaving the category entirely
   - Identify the top 3 competitive threats and what they offer that you do not
   - Evaluate whether your pricing aligns with the value customers actually receive
   - Survey retained customers: what would they miss most if they left
   - Find your "sticky" features — the features that correlate most with long-term retention
   - Build switching costs through integrations, data, workflows, and team adoption

6. CHURN REDUCTION ROADMAP
   - Create a 90-day plan with specific tactics, owners, and target metrics
   - Month 1: Fix the biggest single cause of churn (usually onboarding or payment failure)
   - Month 2: Launch the health score system and proactive at-risk intervention
   - Month 3: Implement the cancellation save flow and win-back campaign
   - Set a target churn rate for each month with accountability checkpoints
   - Project the revenue impact of each 0.5% reduction in monthly churn over 12 months
   - Establish a quarterly churn review process to maintain momentum

Present the analysis as a churn diagnostic dashboard showing current metrics, root cause distribution, risk segmentation, and the prioritized reduction roadmap with projected impact on retention and revenue.

Be specific to my situation. No generic filler.
