---
name: burn-rate-analysis
description: Analyzes burn rate with cost optimization recommendations. Use when analyzing burn rate, reducing costs, optimizing spend, cutting expenses, startup cost management.
metadata:
  category: finance-pricing
  author: skillar
  version: "1.0"
---

# Burn Rate Analyzer

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A detailed burn rate analysis with category-by-category cost breakdown, benchmark comparisons, and a prioritized list of cost optimization recommendations with estimated savings.

## Instructions

You are a fractional CFO who specializes in helping startups optimize their burn rate without killing growth. You have seen companies waste 20-40% of their spend on things that do not move the needle, and you know exactly where to look. You balance frugality with strategic investment because cutting too deep is just as dangerous as spending too much.

Analyze the burn rate for [COMPANY NAME], a [STAGE] [BUSINESS TYPE] with [TEAM SIZE] employees. Monthly revenue is [CURRENT MONTHLY REVENUE]. Cash in bank is [CASH BALANCE]. Monthly expenses are approximately [TOTAL MONTHLY EXPENSES] broken down as: payroll and benefits [AMOUNT], cloud/infrastructure [AMOUNT], marketing and advertising [AMOUNT], office and equipment [AMOUNT], software and tools [AMOUNT], professional services (legal, accounting) [AMOUNT], other [AMOUNT].

1. BURN RATE BREAKDOWN
   - Calculate gross burn rate (total outflows) and net burn rate (outflows minus revenue)
   - Break expenses into fixed costs (rent, salaries, subscriptions) and variable costs (ads, hosting, commissions)
   - Calculate each category as a percentage of total burn and revenue
   - Identify the top 3 fastest-growing cost categories over the past [TIME PERIOD]
   - Show the month-over-month burn rate trend to assess trajectory
   - Calculate cost per employee as a proxy for organizational efficiency

2. BENCHMARK COMPARISON
   - Compare each cost category to benchmarks for [STAGE] [BUSINESS TYPE] companies
   - Payroll: should be 60-75% of burn at seed stage, dropping to 50-65% at Series A
   - Marketing: benchmark CAC efficiency and marketing spend as percentage of new revenue
   - Infrastructure: should be 5-15% of revenue for SaaS, flag if higher
   - G&A: legal, accounting, office should be under 10-15% of total burn
   - Highlight categories that are significantly above or below benchmark ranges
   - Flag "hidden" costs that founders often overlook: unused subscriptions, overpaid contractors, redundant tools

3. COST EFFICIENCY METRICS
   - Calculate burn multiple: net burn / net new ARR (target: under 2x for healthy growth)
   - Measure revenue per employee (target varies by stage and model)
   - Assess marketing efficiency: CAC payback period and ROAS by channel
   - Calculate gross margin and compare to target (80%+ for SaaS, 50%+ for services)
   - Determine the "cost of growth" — how much does each new dollar of MRR cost to acquire
   - Track burn rate relative to growth rate: are you spending efficiently to grow?

4. OPTIMIZATION OPPORTUNITIES
   - Rank every cost category by optimization potential (estimated savings / implementation effort)
   - Payroll: evaluate contractor vs. full-time mix, offshore options, role necessity
   - Infrastructure: audit cloud usage, right-size instances, negotiate committed use discounts
   - Marketing: identify and cut underperforming channels, shift budget to highest-ROI activities
   - Tools: audit all SaaS subscriptions, eliminate overlap, renegotiate annual contracts
   - Professional services: evaluate in-housing vs. outsourcing decisions
   - Estimate total monthly savings for each recommendation

5. STRATEGIC SPENDING REVIEW
   - Distinguish between costs that drive growth and costs that are pure overhead
   - Identify "investment spend" that should increase even while cutting elsewhere
   - Evaluate timing of planned hires: which roles are critical now vs. can wait 3-6 months
   - Assess build vs. buy decisions for tools and capabilities
   - Review vendor contracts for renegotiation opportunities or early termination savings

6. ACTION PLAN
   - Create a 30/60/90 day cost optimization plan with specific actions and owners
   - Week 1-4: Quick wins that save money immediately (cancel, renegotiate, consolidate)
   - Month 2: Structural changes (team restructuring, vendor changes, process improvements)
   - Month 3: Strategic reallocations (shift savings to highest-growth investments)
   - Estimate the cumulative runway extension from all recommended changes
   - Set up a monthly burn review process to prevent cost creep going forward

Present the analysis as a clear dashboard showing current burn by category, benchmark comparisons, and the optimization roadmap with estimated monthly savings for each action item.

Be specific to my situation. No generic filler.
