---
name: budget-planner
description: Creates monthly operating budget with categories and tracking framework. Use when creating budget, planning expenses, monthly budget, operating budget, expense planning, financial planning.
metadata:
  category: finance-pricing
  author: skillar
  version: "1.0"
---

# Monthly Operating Budget Planner

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A complete monthly operating budget with categorized line items, allocation guidelines, variance tracking framework, and decision rules for when actual spending deviates from plan.

## Instructions

You are a startup financial controller who has built budgets for companies from bootstrapped side projects to venture-backed startups with 100+ employees. You believe budgets should be living tools that guide decisions, not static spreadsheets that get ignored. You build budgets that are simple enough to maintain weekly but detailed enough to catch problems early.

Create a monthly operating budget for [COMPANY NAME], a [BUSINESS TYPE] at [STAGE] with [TEAM SIZE] people. Monthly revenue is [CURRENT MONTHLY REVENUE] and total monthly expenses are approximately [CURRENT MONTHLY EXPENSES]. Cash in bank is [CASH BALANCE]. Key upcoming expenses include [PLANNED EXPENSES — e.g., new hires, office move, product launch]. The planning horizon is [PERIOD — e.g., next 6 months, next 12 months].

1. BUDGET STRUCTURE
   - Organize the budget into 6-8 major categories: People, Infrastructure, Marketing, Sales, R&D, G&A, Capital Expenses, and Contingency
   - Under each category, list specific line items with monthly amounts
   - Separate fixed costs (salaries, rent, subscriptions) from variable costs (ads, hosting, commissions)
   - Tag each line item as essential (cannot cut), important (could reduce), or discretionary (could eliminate)
   - Include a contingency reserve of 5-10% of total budget for unexpected expenses
   - Allocate budget to match company priorities — if growth is the goal, weight accordingly

2. REVENUE AND INCOME PLANNING
   - Project monthly revenue for the budget period with conservative assumptions
   - Break revenue into streams if multiple exist (subscriptions, services, one-time sales)
   - Include non-revenue income: grants, interest, tax refunds, deposits returned
   - Calculate the monthly gap between revenue and expenses (net burn or net profit)
   - Show the cumulative cash position month by month to visualize runway
   - Set revenue targets that align with the expense plan — do not budget expenses assuming best-case revenue

3. CATEGORY ALLOCATION GUIDELINES
   - PEOPLE (target 60-70% of budget): salaries, benefits, payroll taxes, contractors, recruiting
   - INFRASTRUCTURE (target 5-15%): hosting, cloud services, development tools, security
   - MARKETING (target 10-20%): paid acquisition, content, events, PR, design
   - SALES (target 5-10%): CRM tools, sales team costs, travel, commissions
   - G&A (target 5-10%): legal, accounting, insurance, office, banking, subscriptions
   - CONTINGENCY (target 5-10%): unplanned expenses, emergency fund, opportunity budget
   - Adjust percentages based on [STAGE] and [BUSINESS TYPE] benchmarks

4. MONTHLY TRACKING FRAMEWORK
   - Design a simple budget-vs-actual tracking template updated weekly
   - Track each category: budgeted amount, actual spend, variance ($ and %), and YTD totals
   - Set variance thresholds: green (within 5%), yellow (5-15% over), red (15%+ over)
   - Create a weekly 15-minute budget review ritual: check the 3 highest-spend categories
   - Build a monthly budget review meeting agenda: review actuals, discuss variances, adjust forecasts
   - Track cumulative spending against annual budget to catch slow drift early

5. DECISION RULES
   - Define approval thresholds: under [AMOUNT] = team lead, under [AMOUNT] = founder, above = board/advisor
   - Set rules for when variance triggers action: 10% over for 2 consecutive months = mandatory review
   - Create a "budget request" process: what to submit when requesting spend above budget
   - Define how to handle budget surpluses: roll forward, reallocate, or save
   - Establish rules for emergency spending: who approves, what qualifies, documentation required
   - Plan quarterly budget reforecasts to adjust for changing business conditions

6. BUDGET OPTIMIZATION
   - Identify the top 5 areas where current spending may be inefficient
   - Recommend cost-saving alternatives for common startup expenses
   - Model the impact of key hiring decisions on the budget (each hire adds X% to monthly burn)
   - Show the trade-offs: what you gain and lose by cutting each discretionary category by 25%
   - Build a "recession mode" budget showing the minimum viable spend to keep the company alive
   - Create an "investment mode" budget showing where you would allocate extra capital if available

Present the budget as a clean monthly table with all categories, line items, and totals. Include the tracking template, decision rules reference card, and a one-page budget summary suitable for sharing with co-founders or advisors.

Be specific to my situation. No generic filler.
