---
name: youtube-strategy
description: Creates a complete YouTube channel strategy with content pillars, growth plan, and optimization. Use when launching a YouTube channel, planning video content, or scaling YouTube growth.
metadata:
  category: social-media
  author: skillar
  version: "1.0"
---

# YouTube Channel Strategy

*Because YouTube is a long game. The ones who win are the ones who don't quit.*

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A comprehensive YouTube channel strategy including content pillars, video formats, SEO optimization plan, thumbnail strategy, and a 90-day growth roadmap to build a sustainable audience.

## Instructions

You are a YouTube growth strategist who has helped channels scale from zero to 100K+ subscribers. You understand the YouTube algorithm, viewer psychology, and the content strategies that drive watch time and subscriptions. Build a complete channel strategy for [CHANNEL NAME] in the [NICHE/TOPIC] space targeting [TARGET AUDIENCE].

1. CHANNEL POSITIONING
   - Define the channel's unique value proposition in 1-2 sentences
   - Identify 3-5 competitor channels and their gaps that [CHANNEL NAME] can fill
   - Establish the creator's on-camera persona and presentation style
   - Write a channel description optimized for YouTube search (under 1000 characters)
   - Create a channel tagline that communicates what subscribers will gain
   - Define the ideal viewer avatar: demographics, pain points, and content consumption habits

2. CONTENT PILLAR FRAMEWORK
   - Define 3-4 content pillars that balance audience demand with creator expertise
   - For each pillar, identify 10 specific video topics with estimated search volume
   - Classify each topic as: discovery (searchable), community (subscriber), or viral (shareable)
   - Establish a content mix ratio across pillars for sustainable growth
   - Map how pillars connect to [MONETIZATION GOAL: ads / sponsorships / products / courses]

3. VIDEO FORMAT PLAYBOOK
   - Design 3-4 repeatable video formats with defined structures
   - For each format, outline: intro hook, segment breakdown, CTA placement, and outro
   - Specify ideal video length for each format based on audience retention patterns
   - Include Shorts strategy: frequency, topics, and how Shorts feed long-form growth
   - Provide scripting templates for each format

4. THUMBNAIL AND TITLE SYSTEM
   - Create a thumbnail style guide: color palette, text rules, face expressions, and composition
   - Write 3 title formulas that drive clicks for each content pillar
   - Explain the curiosity-clarity balance for titles in [NICHE/TOPIC]
   - Provide 10 example title-thumbnail pairings for upcoming videos
   - Include A/B testing strategy for thumbnails

5. SEO AND DISCOVERY OPTIMIZATION
   - Outline keyword research process for video topics in [NICHE/TOPIC]
   - Provide a description template with keyword placement strategy
   - Define tagging strategy and how to use hashtags effectively
   - Explain how to optimize for suggested videos and browse features
   - Include playlist strategy to maximize session watch time

6. 90-DAY GROWTH ROADMAP
   - Month 1: Foundation phase — publishing cadence, baseline content, channel setup
   - Month 2: Optimization phase — analyze data, double down on winners, refine formats
   - Month 3: Acceleration phase — collaborations, cross-promotion, and scaling what works
   - Set specific subscriber and view count milestones for each month
   - Include weekly time allocation for filming, editing, promotion, and community engagement
   - Define key metrics to track weekly and the benchmarks that signal progress

Deliver a complete strategy document that [CHANNEL NAME] can follow week by week, prioritizing actions that drive the fastest path to [SUBSCRIBER GOAL] subscribers.

Be specific to my situation. No generic filler.
