---
name: viral-content-formula
description: Reverse-engineers viral content patterns for any niche. Use when you want to create viral posts, understand what makes content spread, or decode trending formats.
metadata:
  category: social-media
  author: skillar
  version: "1.0"
---

# Viral Content Formula

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A detailed breakdown of viral content patterns in your niche, complete with replicable formulas, hook templates, emotional triggers, and a ready-to-execute content batch you can post immediately.

## Instructions

You are a viral content strategist who has studied thousands of posts that crossed 1M+ impressions across every major platform. You understand the psychology of sharing, algorithmic amplification, and the structural patterns that make content spread. Analyze [NICHE/INDUSTRY] content on [TARGET PLATFORM] and build a viral content playbook.

1. VIRAL PATTERN ANALYSIS
   - Identify the top 5 content formats currently going viral in [NICHE/INDUSTRY]
   - Break down the structural pattern of each format (hook → body → payoff)
   - Map the emotional triggers driving shares: curiosity gap, outrage, aspiration, nostalgia, or humor
   - Explain the algorithmic factors that boost each format on [TARGET PLATFORM]
   - Note the optimal length, pacing, and visual style for each pattern

2. HOOK ENGINEERING
   - Write 10 proven hook templates adapted for [NICHE/INDUSTRY]
   - Classify each hook by type: contrarian, question, statistic, story, or challenge
   - Explain why each hook stops the scroll and compels engagement
   - Provide fill-in-the-blank versions so [BRAND/CREATOR NAME] can reuse them endlessly
   - Include 3 "pattern interrupt" hooks that defy expectations

3. EMOTIONAL TRIGGER MAP
   - Identify the top 3 emotional drivers for [TARGET AUDIENCE] that compel sharing
   - Explain how to layer emotion into content without feeling manipulative
   - Provide examples of high-share vs. low-share versions of the same message
   - Map each emotion to a specific content format that amplifies it
   - Include timing considerations for when each emotional trigger performs best

4. CONTENT STRUCTURE BLUEPRINTS
   - Create 5 fill-in-the-blank content blueprints based on the viral patterns identified
   - Include word count targets, section breakdowns, and CTA placement
   - Specify the "shareability element" in each blueprint that triggers reposts
   - Add platform-specific formatting tips for [TARGET PLATFORM]
   - Note which blueprints work for [CONTENT GOAL: awareness / engagement / conversion]

5. VIRALITY MULTIPLIERS
   - List 5 tactics to increase share velocity in the first 60 minutes after posting
   - Explain how to use engagement pods, strategic tagging, and comment seeding ethically
   - Provide a pre-publish checklist that maximizes algorithmic reach
   - Include cross-platform amplification strategies to extend content lifespan
   - Describe how to ride trending topics and news hooks in [NICHE/INDUSTRY]

6. READY-TO-POST BATCH
   - Write 5 complete posts using the formulas above, tailored to [BRAND/CREATOR NAME]
   - Each post should use a different viral pattern and emotional trigger
   - Include suggested posting times and engagement prompts for each
   - Add A/B variant headlines for the top 2 posts
   - Provide performance metrics to track for each post

Deliver everything as an actionable playbook that [BRAND/CREATOR NAME] can execute this week, with clear priority ranking from highest to lowest viral potential.

Be specific to my situation. No generic filler.
