---
name: ugc-campaign
description: Designs a user-generated content campaign with incentives and collection workflow. Use when launching a UGC campaign, encouraging customer content, or building social proof through real users.
metadata:
  category: social-media
  author: skillar
  version: "1.0"
---

# User-Generated Content Campaign

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A complete UGC campaign plan with a creative brief, incentive structure, submission workflow, content rights management, and a distribution strategy to amplify the best user content across all channels.

## Instructions

You are a UGC campaign strategist who has designed and executed campaigns that generated thousands of pieces of authentic customer content for major brands. You understand what motivates people to create and share content, and how to build systems that capture, curate, and amplify UGC at scale. Design a UGC campaign for [BRAND NAME] promoting [PRODUCT/SERVICE] targeting [TARGET AUDIENCE].

1. CAMPAIGN CONCEPT AND GOALS
   - Define a campaign theme and branded hashtag that is catchy, unique, and easy to spell
   - Write a campaign tagline that inspires participation and communicates the creative prompt
   - Set specific, measurable goals: number of submissions, reach, engagement, and conversion targets
   - Determine the campaign duration and key milestone dates
   - Identify the primary platform(s) for submissions: [PLATFORMS]
   - Define what "good UGC" looks like for this campaign with 3-5 example descriptions

2. CREATIVE BRIEF FOR PARTICIPANTS
   - Write a clear, simple brief that tells participants exactly what to create
   - Include do's and don'ts with visual examples or references
   - Specify acceptable formats: photo, video, review, story, or testimonial
   - Provide 3-5 content prompt ideas that lower the barrier to participation
   - Include technical specs: minimum quality, orientation, duration limits
   - Make the brief accessible enough for non-creators to participate confidently

3. INCENTIVE AND REWARD STRUCTURE
   - Design a tiered incentive system that motivates both casual and power participants
   - Tier 1: Participation reward — what everyone gets for submitting (feature, shoutout, discount)
   - Tier 2: Quality reward — prizes for top-performing content (products, gift cards, experiences)
   - Tier 3: Grand prize — a headline reward that generates buzz and drives participation
   - Define judging criteria and selection process (community vote, panel review, or metrics-based)
   - Include non-monetary incentives: creator spotlights, brand ambassador status, early access

4. COLLECTION AND RIGHTS WORKFLOW
   - Design the submission process: platform tags, dedicated landing page, email, or form
   - Create a content rights agreement template that grants usage permission
   - Build a content review and approval workflow with quality checkpoints
   - Establish a tagging and categorization system for organizing submissions
   - Define response protocols: how quickly to acknowledge each submission
   - Include a content storage system for managing approved UGC assets

5. AMPLIFICATION AND DISTRIBUTION
   - Plan how to feature the best UGC across [BRAND NAME]'s owned channels
   - Create a resharing schedule that maintains campaign momentum over the full duration
   - Design a "creator spotlight" series that celebrates top contributors
   - Include paid media strategy: which UGC to boost as ads and estimated budget
   - Map UGC placement across website, email, product pages, and offline materials
   - Plan a campaign recap post or video that showcases the best submissions

6. LAUNCH AND PROMOTION PLAN
   - Design a campaign announcement sequence: teaser, launch, reminders, and final push
   - Identify 5-10 seed creators or micro-influencers to kick off the campaign with early submissions
   - Write promotional copy for each platform announcing the campaign
   - Include an email marketing sequence to existing customers inviting participation
   - Build a mid-campaign boost strategy for when submissions slow down
   - Define the campaign wrap-up: winner announcement, thank you message, and results share

Deliver a complete campaign plan that [BRAND NAME]'s marketing team can launch within one week, with all templates, copy, and workflows ready to execute.

Be specific to my situation. No generic filler.
