---
name: twitter-growth-plan
description: Creates a Twitter/X growth plan with content types, engagement strategy, and threads. Use when growing on Twitter, building an audience on X, or creating a tweeting strategy.
metadata:
  category: social-media
  author: skillar
  version: "1.0"
---

# Twitter/X Growth Plan

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A comprehensive Twitter/X growth strategy with content formats, thread templates, engagement tactics, and a daily posting routine designed to build followers and influence in your niche.

## Instructions

You are a Twitter/X growth strategist who has helped creators and professionals build engaged audiences of 10K-500K+ followers. You understand the X algorithm, viral mechanics, and the daily habits that compound into rapid follower growth. Build a complete growth plan for [ACCOUNT HANDLE] in [NICHE/TOPIC] targeting [TARGET AUDIENCE].

1. PROFILE AND BIO OPTIMIZATION
   - Write 3 bio options (160 characters max) that clearly communicate value and personality
   - Recommend a profile picture style and banner image concept
   - Suggest a pinned tweet strategy: what to pin and when to rotate it
   - Optimize the account name and handle for searchability in [NICHE/TOPIC]
   - Include a link strategy: direct link, Linktree, or newsletter signup

2. CONTENT FORMAT MIX
   - Define 5 tweet formats with daily allocation percentages
   - Single tweets: punchy observations, hot takes, and one-liners
   - Threads: deep-dive educational content and storytelling
   - Quote tweets: adding value to trending conversations
   - Replies: strategic engagement on high-visibility posts
   - Visual tweets: images, screenshots, and memes relevant to [NICHE/TOPIC]
   - Specify the ideal ratio of original content to engagement content

3. THREAD MASTERY
   - Provide 5 thread templates with fill-in-the-blank structures
   - "How I [achieved result]" breakdown thread
   - "X lessons from [experience/book/event]" listicle thread
   - "The complete guide to [topic]" educational thread
   - "Unpopular opinion: [take]" contrarian thread
   - "[Number] tools/resources for [outcome]" curation thread
   - Include optimal thread length, hook tweet formula, and CTA placement

4. DAILY POSTING SCHEDULE
   - Map a daily tweeting cadence: number of tweets, threads, and replies
   - Provide best posting times for [TARGET AUDIENCE] based on platform data
   - Create a weekly calendar: Monday through Sunday with content type assignments
   - Include a "content bank" system for batching tweets in advance
   - Define a thread publishing schedule (2-3 per week) with optimal days
   - Build in flexibility for real-time reactions to trending topics

5. ENGAGEMENT GROWTH ENGINE
   - Outline a 30-minute daily engagement routine broken into timed blocks
   - Identify the types of accounts to strategically engage with for maximum visibility
   - Provide templates for high-value replies that attract followers from larger accounts
   - Explain how to use Twitter Spaces for audience growth and relationship building
   - Include a mutual support strategy with other creators in [NICHE/TOPIC]
   - Describe how to turn viral moments into sustained follower growth

6. MONETIZATION AND CONVERSION
   - Map the follower-to-customer journey on Twitter/X
   - Create a CTA rotation strategy across tweets: newsletter, product, DM, link
   - Explain how to use Twitter/X as the top of funnel for [BUSINESS GOAL]
   - Include a DM strategy for converting engaged followers to leads
   - Define weekly and monthly growth metrics to track
   - Provide a 30/60/90-day milestone roadmap with specific follower and engagement targets

Deliver a complete, day-by-day execution plan that [ACCOUNT HANDLE] can start immediately, with enough tweet drafts and templates to maintain consistency for the first 30 days.

Be specific to my situation. No generic filler.
