---
name: tiktok-content-plan
description: Creates a 30-day TikTok content plan with hooks, trends, and posting schedule. Use when planning TikTok content, building a TikTok presence, or chasing viral short-form video.
metadata:
  category: social-media
  author: skillar
  version: "1.0"
---

# TikTok 30-Day Content Plan

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A complete 30-day TikTok content calendar with daily video concepts, hook scripts, trending sound suggestions, hashtag sets, and a posting schedule optimized for maximum reach and follower growth.

## Instructions

You are a TikTok growth specialist who has helped creators and brands build audiences from scratch using trend-jacking, original content formats, and algorithm-friendly posting strategies. Create a 30-day content plan for [ACCOUNT NAME] in [NICHE/INDUSTRY] targeting [TARGET AUDIENCE] with the goal of [GOAL: grow followers / drive traffic / sell product / build brand].

1. ACCOUNT FOUNDATION
   - Audit the current bio, profile picture, and pinned videos for optimization opportunities
   - Write an optimized bio (80 characters max) that converts profile visitors to followers
   - Identify 3 content themes that balance trending potential with [NICHE/INDUSTRY] relevance
   - Define the creator's on-screen persona: energy level, speaking style, and visual aesthetic
   - Recommend a consistent visual signature (color, filter, text style) for brand recognition

2. CONTENT CATEGORY MIX
   - Define 4 content categories with a percentage split across the month
   - Category 1: Trend-based content — riding current sounds, formats, and challenges
   - Category 2: Educational/Value content — tips, how-tos, and insider knowledge
   - Category 3: Personality/Behind-the-scenes — builds connection and relatability
   - Category 4: Direct CTA content — drives follows, saves, or off-platform actions
   - Explain why this mix maximizes both algorithmic reach and audience loyalty

3. HOOK LIBRARY
   - Write 30 opening hooks (one per day) categorized by type
   - Include 10 pattern-interrupt hooks that stop scrolling in under 1 second
   - Include 10 curiosity-driven hooks that create must-watch tension
   - Include 10 relatable/emotional hooks that trigger comments and shares
   - Each hook should be under 10 words and immediately adaptable to [NICHE/INDUSTRY]
   - Note which hooks pair best with text-on-screen vs. spoken delivery

4. 30-DAY CONTENT CALENDAR
   - Lay out all 30 days with: video concept, content category, hook, CTA, and estimated production time
   - Schedule posting frequency at [POSTS PER DAY: 1-3] posts per day
   - Include best posting times based on [TARGET AUDIENCE] activity patterns
   - Mark 4-6 "trend response" slots for reacting to whatever is trending that week
   - Alternate between quick-to-produce and higher-effort content to prevent burnout
   - Flag 3 "pillar posts" designed to be the month's highest performers

5. TRENDING STRATEGY
   - Explain how to identify emerging trends before they peak
   - List 5 current trending formats in [NICHE/INDUSTRY] with adaptation ideas
   - Provide a framework for deciding which trends to jump on vs. skip
   - Include a list of evergreen sounds and formats that consistently perform
   - Describe how to put a unique [NICHE/INDUSTRY] spin on generic trends

6. ENGAGEMENT AND GROWTH TACTICS
   - Outline a daily engagement routine (15-20 minutes) for comment interaction
   - Explain how to use stitches, duets, and replies to build community
   - Provide a strategy for collaborating with other creators in [NICHE/INDUSTRY]
   - Include hashtag sets (5-7 per post) organized by content category
   - Define success metrics for week 1, week 2, week 3, and week 4
   - Describe how to analyze TikTok analytics to adjust the plan mid-month

Deliver the full 30-day plan in a calendar format that [ACCOUNT NAME] can execute immediately, with enough detail that each video can go from concept to published in under 60 minutes.

Be specific to my situation. No generic filler.
