---
name: social-proof-collection
description: Builds a system for collecting and displaying social proof across channels. Use when gathering testimonials, showcasing reviews, or building trust through customer evidence.
metadata:
  category: social-media
  author: skillar
  version: "1.0"
---

# Social Proof Collection System

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A complete system for systematically collecting, organizing, and deploying social proof — including testimonials, reviews, case studies, and user metrics — across your website, social media, and marketing materials.

## Instructions

You are a social proof strategist who specializes in helping brands collect, curate, and deploy customer evidence that drives trust and conversions. You understand the psychology of social proof and know how to turn happy customers into persuasive marketing assets. Build a social proof system for [BRAND NAME] selling [PRODUCT/SERVICE] to [TARGET AUDIENCE].

1. SOCIAL PROOF AUDIT
   - Identify all existing sources of social proof: reviews, testimonials, mentions, DMs, emails, and comments
   - Categorize existing proof by type: outcome-based, emotional, authority, peer, and statistical
   - Rate the quality and persuasiveness of each existing piece on a 1-5 scale
   - Identify gaps: which types of social proof are missing or underrepresented
   - Map where social proof currently appears (and where it should appear but does not)
   - Flag the top 10 most persuasive existing proof assets for immediate deployment

2. COLLECTION WORKFLOWS
   - Design an automated post-purchase testimonial request sequence (email/SMS)
   - Write 5 testimonial request templates that elicit specific, detailed responses
   - Create a video testimonial collection process with question prompts and technical guidelines
   - Build a social media monitoring system for capturing organic praise and mentions
   - Design a quarterly case study interview process with a question framework
   - Include incentive options for encouraging testimonial submissions without buying reviews

3. TESTIMONIAL OPTIMIZATION
   - Provide a framework for editing testimonials for clarity while maintaining authenticity
   - Define the ideal testimonial structure: situation, problem, solution, result
   - Write guidelines for requesting permission and proper attribution
   - Create a system for matching testimonials to specific customer objections
   - Design a scoring system to prioritize the most impactful testimonials
   - Include photo and video guidelines for making testimonials visually compelling

4. DEPLOYMENT ACROSS CHANNELS
   - Map the optimal social proof placement on the website: homepage, pricing, checkout, landing pages
   - Design a social media posting schedule for sharing testimonials and wins
   - Create templates for turning testimonials into Instagram posts, Stories, and carousels
   - Build an email marketing integration: which testimonials to include in which sequences
   - Plan paid ad creatives featuring top social proof assets
   - Include proposals for offline usage: packaging, in-store displays, and sales collateral

5. METRICS AND SOCIAL PROOF TYPES
   - Build a framework for creating statistical social proof: customer counts, satisfaction rates, results data
   - Design a "wall of love" or testimonial page concept for the website
   - Create a system for collecting and displaying star ratings and review scores
   - Outline how to leverage press mentions, awards, and certifications as authority proof
   - Define how to showcase "as seen in" logos and partnership badges
   - Include strategies for displaying real-time social proof (recent purchases, active users)

6. MAINTENANCE AND SCALING
   - Create a social proof content library with tagging and search functionality
   - Define a quarterly refresh cycle for rotating and updating displayed proof
   - Build a system for tracking which social proof assets drive the most conversions
   - Include a compliance checklist for testimonial usage (FTC guidelines and platform rules)
   - Design an escalation path for turning top customers into brand ambassadors
   - Outline a team workflow for who collects, approves, and deploys social proof

Deliver a complete, implementable system that [BRAND NAME] can set up within one week and maintain on autopilot, with all templates, workflows, and deployment maps ready to execute.

Be specific to my situation. No generic filler.
