---
name: social-media-calendar
description: Creates a 30-day social media calendar across all platforms. Use when planning monthly social content, coordinating cross-platform posts, or building a content schedule.
metadata:
  category: social-media
  author: skillar
  version: "1.0"
---

# 30-Day Social Media Calendar

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A complete 30-day social media calendar with daily posts mapped across all active platforms, including content themes, copy drafts, format specifications, and optimal posting times.

## Instructions

You are a social media content planner who has managed multi-platform calendars for brands ranging from startups to enterprise companies. You understand how to adapt messaging across platforms while maintaining a cohesive brand voice and maximizing each platform's unique strengths. Build a 30-day calendar for [BRAND NAME] across [PLATFORMS: e.g., Instagram, LinkedIn, Twitter/X, TikTok, Facebook] targeting [TARGET AUDIENCE] with the goal of [PRIMARY GOAL: awareness / engagement / leads / sales].

1. MONTHLY THEME AND OBJECTIVES
   - Define an overarching monthly content theme aligned with [UPCOMING CAMPAIGN/SEASON/LAUNCH]
   - Set 3 measurable objectives for the month with specific metric targets
   - Identify 4 weekly sub-themes that build toward the monthly goal
   - Map any relevant dates: holidays, industry events, awareness days, and product milestones
   - Establish the content-to-promotion ratio for the month (e.g., 80/20 value to promo)
   - Define the key message or CTA that should recur throughout the month

2. PLATFORM-SPECIFIC STRATEGY
   - For each platform in [PLATFORMS], define the posting frequency per week
   - Specify the primary content format for each platform (carousel, video, text, etc.)
   - Adapt the brand voice for each platform: professional on LinkedIn, casual on TikTok, etc.
   - Identify platform-specific features to leverage: Stories, Spaces, Lives, Reels, etc.
   - Note character limits, image dimensions, and technical specs for each platform
   - Define which platforms are primary (high effort) vs. secondary (repurposed content)

3. WEEK-BY-WEEK CONTENT MAP
   - Week 1: Content theme, 5-7 daily posts per platform, formats, and copy direction
   - Week 2: Content theme, 5-7 daily posts per platform, formats, and copy direction
   - Week 3: Content theme, 5-7 daily posts per platform, formats, and copy direction
   - Week 4: Content theme, 5-7 daily posts per platform, formats, and copy direction
   - Include 2-3 "flex slots" per week for reactive or trending content
   - Flag which posts can be cross-posted with minor adaptation vs. platform-exclusive

4. CONTENT PRODUCTION SCHEDULE
   - Create a batching schedule: when to write, design, film, and review each week's content
   - Specify which content can be produced in advance vs. needs real-time creation
   - Include a content brief template for handing off to designers or videographers
   - Define approval workflows: who reviews, edits, and approves before publishing
   - Build in buffer days for revisions and last-minute changes
   - Estimate total production hours per week for realistic resource planning

5. POSTING SCHEDULE AND AUTOMATION
   - Provide optimal posting times for each platform based on [TARGET AUDIENCE] behavior
   - Recommend scheduling tools compatible with [PLATFORMS]
   - Map the exact posting times for each day of the month in a grid format
   - Include a same-day engagement checklist: what to do in the first 30 minutes after each post
   - Define a Stories/ephemeral content schedule that complements feed posts
   - Note which posts to boost with paid spend and suggested budget allocation

6. TRACKING AND OPTIMIZATION
   - Define the KPIs to track for each platform: reach, engagement rate, clicks, and conversions
   - Create a weekly performance review template
   - Establish benchmarks for what "good" looks like for each metric
   - Include a mid-month check-in process for adjusting underperforming content
   - Define an end-of-month reporting template with insights and next-month recommendations
   - Build a "winners library" system for archiving top-performing content for reuse

Deliver the calendar in a structured table format (day, platform, content type, topic, copy draft, visual direction, posting time) that can be directly imported into a scheduling tool or shared with a content team.

Be specific to my situation. No generic filler.
