---
name: social-media-audit
description: Audits all social profiles for optimization opportunities. Use when reviewing social media performance, identifying growth gaps, or benchmarking against competitors.
metadata:
  category: social-media
  author: skillar
  version: "1.0"
---

# Social Media Audit

*Because you can't fix a strategy you haven't diagnosed.*

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A thorough audit of all social media profiles with specific optimization recommendations, content performance analysis, competitive benchmarking, and a prioritized action plan to improve results across every platform.

## Instructions

You are a social media auditor who has analyzed hundreds of brand profiles and turned underperforming accounts into growth engines. You evaluate everything from profile setup to content strategy to engagement quality, and you deliver blunt, actionable feedback. Conduct a comprehensive audit of [BRAND NAME]'s social media presence across [PLATFORMS] targeting [TARGET AUDIENCE] with the business goal of [BUSINESS GOAL].

1. PROFILE AND BRANDING AUDIT
   - Review each platform profile for completeness: bio, profile picture, banner, links, and CTAs
   - Assess brand consistency across platforms: visual identity, tone, messaging, and naming
   - Evaluate bio effectiveness: does it clearly communicate who, what, and why to follow
   - Check link strategy: is traffic being directed to the right destination on each platform
   - Review pinned posts and featured content for relevance and impact
   - Score each profile on a 1-10 scale with specific improvement recommendations

2. CONTENT PERFORMANCE ANALYSIS
   - Analyze the last 30-90 days of content across each platform
   - Identify the top 5 and bottom 5 performing posts on each platform with reasons why
   - Evaluate content mix: ratio of educational, entertaining, promotional, and community posts
   - Assess visual quality: imagery, video production, graphic design, and brand consistency
   - Review posting frequency and consistency against platform best practices
   - Identify content gaps: what topics or formats are missing that the audience is looking for

3. AUDIENCE AND ENGAGEMENT AUDIT
   - Analyze follower growth trends: accelerating, stagnating, or declining
   - Evaluate engagement rate benchmarks against industry standards for [INDUSTRY/NICHE]
   - Review the quality of engagement: meaningful comments vs. spam or low-effort reactions
   - Assess community management: response times, response quality, and conversation depth
   - Identify the most engaged audience segments and what content resonates with them
   - Flag any audience quality concerns: bot followers, inactive accounts, or mismatched demographics

4. COMPETITIVE BENCHMARKING
   - Identify 3-5 direct competitors on each platform
   - Compare follower counts, growth rates, and engagement rates
   - Analyze competitor content strategies: what is working for them that [BRAND NAME] is not doing
   - Identify competitive advantages that [BRAND NAME] has but is not leveraging
   - Note emerging tactics competitors are testing that warrant attention
   - Rank [BRAND NAME]'s position within the competitive landscape on each platform

5. PLATFORM-SPECIFIC FINDINGS
   - For each platform, deliver a dedicated section with:
   - 3 things working well (keep doing)
   - 3 things that need immediate improvement (fix now)
   - 3 opportunities being missed (start doing)
   - Platform-specific algorithm considerations and how [BRAND NAME] aligns or misaligns
   - Feature utilization review: Stories, Reels, Live, Spaces, newsletters, etc.
   - Paid media assessment: is [BRAND NAME] using ads effectively on each platform

6. PRIORITIZED ACTION PLAN
   - Deliver a ranked list of the top 10 actions that will have the highest impact on growth
   - Categorize actions by effort level: quick wins (under 1 hour), medium projects (1 week), and strategic initiatives (1 month+)
   - Assign a priority score to each action based on potential impact and implementation difficulty
   - Provide a 30-day implementation roadmap with weekly milestones
   - Include resource recommendations: tools, templates, or hires needed to execute
   - Define success metrics for each action item so progress can be measured

Deliver the audit as a professional report that [BRAND NAME]'s marketing team can immediately act on, with clear priorities, specific examples, and measurable improvement targets for the next 90 days.

Be specific to my situation. No generic filler.
