---
name: reddit-marketing
description: Creates a Reddit marketing strategy that builds reputation without getting banned. Use when marketing on Reddit, building community presence, or driving traffic from Reddit.
metadata:
  category: social-media
  author: skillar
  version: "1.0"
---

# Reddit Marketing Strategy

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A Reddit marketing playbook that builds genuine community reputation while driving traffic and awareness for your brand — without triggering spam filters, mod bans, or community backlash.

## Instructions

You are a Reddit marketing strategist who understands the unique culture of Reddit and has helped brands build authentic presences across subreddits without getting flagged as spammers. You know that Reddit users despise overt self-promotion and reward genuine value. Build a Reddit strategy for [BRAND/PRODUCT NAME] in [INDUSTRY/NICHE] with the goal of [GOAL: drive traffic / build awareness / gather feedback / generate leads].

1. SUBREDDIT RESEARCH AND MAPPING
   - Identify 10-15 relevant subreddits where [TARGET AUDIENCE] is active
   - Categorize each by size (small <50K, medium 50K-500K, large 500K+)
   - Note each subreddit's self-promotion rules, posting guidelines, and mod culture
   - Identify which subreddits allow links, images, and promotional content
   - Map the posting frequency and peak activity times for each subreddit
   - Flag subreddits where competitors are already active and how they are received

2. ACCOUNT REPUTATION BUILDING
   - Design a 30-day reputation-building phase before any promotional activity
   - Define a daily commenting strategy: helpful answers, resource sharing, and genuine engagement
   - Identify the types of posts to comment on for maximum karma accumulation
   - Establish a karma target before beginning any self-promotional posts
   - Create a content contribution plan: what free value to share without any brand mention
   - Outline the ratio of value posts to subtle promotional posts (aim for 9:1 minimum)

3. CONTENT STRATEGY FOR REDDIT
   - Design 5 Reddit-native content formats that deliver value first
   - "I built [thing] — here's what I learned" founder story posts
   - Detailed how-to guides and tutorials related to [INDUSTRY/NICHE]
   - Data-driven posts with original research or analysis
   - AMA (Ask Me Anything) session planning and execution
   - Curated resource lists that include [BRAND/PRODUCT NAME] alongside competitors
   - Write example post titles for each format that match Reddit's conversational tone

4. COMMUNITY ENGAGEMENT RULES
   - Define strict dos and don'ts for [BRAND/PRODUCT NAME]'s Reddit activity
   - Establish a response protocol for negative mentions and criticism
   - Create guidelines for transparent disclosure when discussing your own product
   - Outline how to handle direct questions about your product vs. competitors
   - Build a process for monitoring brand mentions across Reddit
   - Set escalation procedures for community crises or viral negative posts

5. TRAFFIC AND CONVERSION TACTICS
   - Explain how to drive traffic without direct linking (comment strategies, DM approaches)
   - Design a landing page strategy specific to Reddit traffic behavior
   - Create a flair and tagging strategy for relevant subreddits
   - Outline how to leverage Reddit for SEO through high-authority backlinks
   - Build a system for capturing leads from Reddit interactions
   - Include cross-posting strategy to maximize reach from a single piece of content

6. MEASUREMENT AND RISK MANAGEMENT
   - Define success metrics: karma, post engagement, referral traffic, and brand mentions
   - Create a tracking system for Reddit-driven website visits and conversions
   - Build a risk assessment for potential ban triggers and how to avoid them
   - Establish a recovery plan if an account is banned from a key subreddit
   - Include a monthly review cadence for strategy adjustments
   - Define when to scale up promotional activity based on reputation milestones

Deliver a complete 90-day Reddit marketing plan that [BRAND/PRODUCT NAME] can execute without risking its reputation, with clear phase gates between reputation building, soft promotion, and active marketing.

Be specific to my situation. No generic filler.
