---
name: podcast-launch
description: Creates a podcast launch plan covering format, equipment, guests, distribution, and growth. Use when starting a podcast, planning a show, or launching an audio content strategy.
metadata:
  category: social-media
  author: skillar
  version: "1.0"
---

# Podcast Launch Plan

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A complete podcast launch plan from concept to first episode, including show format, equipment recommendations, guest strategy, distribution setup, and a promotional plan to build an audience from day one.

## Instructions

You are a podcast launch consultant who has helped creators and brands launch shows that hit the top charts in their category. You understand audio production, audience building, and the podcast ecosystem from hosting platforms to promotion channels. Build a launch plan for [PODCAST NAME] hosted by [HOST NAME/BRAND] covering [TOPIC/NICHE] for [TARGET LISTENER].

1. SHOW CONCEPT AND FORMAT
   - Define the show's unique angle and positioning within [TOPIC/NICHE]
   - Write a podcast description (250 words max) optimized for Apple Podcasts and Spotify search
   - Choose and justify the format: solo, interview, co-hosted, narrative, or hybrid
   - Define the ideal episode length based on [TARGET LISTENER] habits and competition analysis
   - Establish the publishing cadence: weekly, biweekly, or twice weekly with rationale
   - Create 3 episode segment templates that provide structure while allowing flexibility
   - Design a signature intro and outro script with consistent branding elements

2. TECHNICAL SETUP
   - Recommend equipment at three budget levels: starter ($100), mid ($300), and pro ($800+)
   - Specify microphone, headphones, audio interface, and recording software for each tier
   - Define the recording environment setup for optimal audio quality
   - Recommend a hosting platform based on features, analytics, and distribution needs
   - Outline the post-production workflow: editing, mixing, mastering, and export settings
   - Include remote recording setup for guest interviews: platform, backup recording, and quality checks

3. CONTENT PIPELINE
   - Generate 20 episode topic ideas organized by content pillar
   - Create a season structure: how many episodes per season and thematic arcs
   - Design an episode planning template: research, outline, talking points, and show notes
   - Build a 3-month content calendar with episode topics, recording dates, and publish dates
   - Include a "bank episodes" strategy: always have 2-4 episodes recorded ahead of schedule
   - Define the show notes template: summary, timestamps, links, and CTA

4. GUEST STRATEGY
   - Define the ideal guest profile: expertise level, audience size, and relevance to [TOPIC/NICHE]
   - Write 3 guest outreach email templates: cold, warm introduction, and follow-up
   - Create a guest preparation packet: what to expect, technical requirements, and promotion asks
   - Build a "dream guest" list of 20 targets tiered by reachability
   - Design a guest booking workflow: outreach, scheduling, prep call, recording, and follow-up
   - Include a strategy for leveraging guest audiences to grow [PODCAST NAME]'s listenership

5. LAUNCH STRATEGY
   - Plan a launch with 3-5 episodes available on day one for binge listening
   - Design a pre-launch promotion timeline: 4-6 weeks of teaser content
   - Create a launch announcement plan across [HOST NAME/BRAND]'s existing channels
   - Build a "launch team" strategy: recruit 50-100 people to listen, subscribe, and review on day one
   - Write email and social media copy for launch week promotions
   - Include a strategy for pursuing "New and Noteworthy" or chart placement on Apple Podcasts

6. GROWTH AND MONETIZATION ROADMAP
   - Define the top 5 podcast growth metrics to track weekly
   - Outline a social media content strategy for promoting each episode: audiograms, clips, quotes
   - Design a listener engagement system: Q&A segments, voicemail, and community building
   - Map the monetization timeline: when to pursue sponsorships, premium content, or merchandise
   - Include a cross-promotion strategy with other podcasts in [TOPIC/NICHE]
   - Create a 6-month growth roadmap with download targets and milestone celebrations

Deliver a complete launch blueprint that [HOST NAME/BRAND] can execute step by step, from purchasing equipment today to publishing the first episode within [LAUNCH TIMELINE: 4-8 weeks].

Be specific to my situation. No generic filler.
