---
name: platform-launch-plan
description: Creates a strategy for launching your brand on a new social platform. Use when joining a new social network, expanding to a new platform, or building a presence from scratch.
metadata:
  category: social-media
  author: skillar
  version: "1.0"
---

# New Platform Launch Plan

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A step-by-step plan for launching your brand on a new social media platform, from profile setup through the critical first 90 days of content and community building.

## Instructions

You are a social media launch strategist who has helped brands successfully enter new platforms and build engaged audiences from zero. You understand that each platform has unique culture, algorithms, and audience expectations, and that early moves set the tone for long-term growth. Build a launch plan for [BRAND NAME] entering [NEW PLATFORM] from [EXISTING PLATFORMS] targeting [TARGET AUDIENCE].

1. PLATFORM ASSESSMENT
   - Analyze why [NEW PLATFORM] is the right strategic move for [BRAND NAME] right now
   - Profile the platform's core demographics and how they overlap with [TARGET AUDIENCE]
   - Identify the content formats that perform best on [NEW PLATFORM]
   - Research the platform's algorithm priorities: what gets boosted vs. suppressed
   - Study 5 brands in [INDUSTRY/NICHE] already succeeding on [NEW PLATFORM] and their tactics
   - Define what success looks like at 30, 60, and 90 days with specific metric targets

2. PROFILE AND BRAND SETUP
   - Optimize the profile: username, bio, profile picture, and cover/banner for [NEW PLATFORM]
   - Write a platform-specific bio that fits the culture and character limits
   - Define the visual identity adaptation: how to maintain brand consistency while fitting platform norms
   - Plan the first 3-5 pinned or featured posts that establish brand identity
   - Set up all platform-specific features: shop, links, highlights, categories, etc.
   - Create a link strategy connecting [NEW PLATFORM] to existing properties

3. CONTENT ADAPTATION STRATEGY
   - Audit existing content from [EXISTING PLATFORMS] for repurposing potential
   - Define which content translates directly vs. needs significant adaptation
   - Create 3-4 native content formats designed specifically for [NEW PLATFORM]
   - Establish the brand voice adjustment: how tone and language shift for this audience
   - Build a content production workflow that adds [NEW PLATFORM] without overwhelming the team
   - Define the posting frequency ramp-up: start conservative, scale based on performance

4. LAUNCH SEQUENCE
   - Week 1: Profile live, announcement on existing channels, first 5-7 posts published
   - Week 2: Daily posting begins, active engagement and community participation
   - Week 3: First campaign or content series launch, collaboration outreach
   - Week 4: Performance review, strategy adjustment, and scaling what works
   - Include a cross-promotion plan to migrate existing audience to [NEW PLATFORM]
   - Design a launch moment: giveaway, exclusive content, or live event to drive initial followers

5. COMMUNITY AND ENGAGEMENT PLAN
   - Map the key communities, groups, and influencers on [NEW PLATFORM] to engage with
   - Design a daily engagement routine specific to [NEW PLATFORM]'s features and culture
   - Identify 10-20 accounts to build relationships with for mutual growth
   - Create a commenting and collaboration strategy that builds visibility
   - Define the community management approach for this platform
   - Include a plan for handling trolls and negativity specific to [NEW PLATFORM]'s culture

6. MEASUREMENT AND ITERATION
   - Define the 5 KPIs to track weekly during the launch phase
   - Create a weekly review template comparing performance against benchmarks
   - Build a content performance tracking system to identify winners and losers
   - Set decision triggers: what metrics indicate "double down" vs. "pivot"
   - Include a 90-day review framework for deciding resource allocation going forward
   - Define the handoff process from launch mode to ongoing management

Deliver a complete, week-by-week launch plan that [BRAND NAME]'s team can execute confidently, with clear ownership, timelines, and decision points mapped for the full 90-day launch window.

Be specific to my situation. No generic filler.
