---
name: live-stream-plan
description: Creates a live stream plan with topic, structure, engagement tactics, and repurposing. Use when planning a live stream, going live on social media, or building a live content strategy.
metadata:
  category: social-media
  author: skillar
  version: "1.0"
---

# Live Stream Plan

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A complete live stream plan including topic selection, minute-by-minute run sheet, audience engagement tactics, technical setup, and a repurposing strategy to extract maximum value from every live session.

## Instructions

You are a live stream strategist who has produced high-engagement live broadcasts for creators and brands across Instagram Live, YouTube Live, LinkedIn Live, TikTok Live, and Twitch. You understand how to keep viewers watching, drive real-time interaction, and turn a single live session into weeks of content. Plan a live stream for [BRAND/CREATOR NAME] on [PLATFORM] about [TOPIC] targeting [TARGET AUDIENCE].

1. PRE-STREAM PLANNING
   - Define the live stream's primary objective: [GOAL: educate / launch product / build community / sell / entertain]
   - Choose the optimal day and time based on [TARGET AUDIENCE] online behavior
   - Determine stream duration: [LENGTH: 30 / 45 / 60 / 90] minutes
   - Create a compelling stream title and description that drives tune-in
   - Design a promotional plan: 3 pre-stream announcements across channels in the 48 hours before going live
   - Prepare a backup plan for technical failures: alternative device, backup internet, pre-recorded segments

2. TECHNICAL SETUP CHECKLIST
   - Specify camera, microphone, and lighting requirements for professional quality
   - Recommend streaming software and multi-platform simulcast options
   - Define the on-screen layout: camera position, lower thirds, graphics, and overlays
   - Include a pre-stream technical test checklist: audio levels, internet speed, lighting, and framing
   - Plan the background and set design for visual appeal and brand consistency
   - Note platform-specific technical requirements and best practices for [PLATFORM]

3. RUN SHEET AND CONTENT STRUCTURE
   - Create a minute-by-minute run sheet with topic transitions and timing cues
   - Minutes 0-5: Opening hook, welcome, and preview of what viewers will learn
   - Minutes 5-15: Core content block 1 with audience interaction point
   - Minutes 15-25: Core content block 2 with live demo, story, or guest segment
   - Minutes 25-35: Q&A or audience participation segment
   - Minutes 35-45: Wrap-up, key takeaways, and CTA
   - Include transition phrases for moving between segments smoothly
   - Build in buffer time for unexpected moments and audience responses

4. ENGAGEMENT TACTICS
   - Design 5 interactive moments to boost real-time participation
   - Include poll or quiz questions to ask viewers at specific timestamps
   - Plan a comment response strategy: how to acknowledge and feature viewer comments
   - Create a "challenge" or "giveaway" moment that spikes viewer count mid-stream
   - Prepare pinned comment text with key links and CTAs
   - Design a call-and-response moment that builds energy and community
   - Include tactics for re-engaging viewers who joined late

5. GUEST OR CO-HOST STRATEGY
   - Define whether the stream benefits from a guest or co-host for [TOPIC]
   - If including a guest: prepare 5-7 interview questions with follow-up prompts
   - Create a guest briefing document: format, timing, technical requirements, and talking points
   - Plan the guest introduction and transition for bringing them on and off screen
   - Design a segment structure that balances host authority with guest expertise
   - Include contingency plans if the guest has technical issues

6. REPURPOSING AND POST-STREAM WORKFLOW
   - Identify 5-8 content pieces to extract from the stream: clips, quotes, highlights, and audiograms
   - Define clip lengths and formats for each platform: 15-sec TikTok, 60-sec Reel, 3-min YouTube
   - Create a post-stream editing checklist for the repurposing team
   - Plan the replay strategy: where and how to make the full recording available
   - Write a follow-up post summarizing key takeaways for those who missed the live
   - Include a viewer feedback collection mechanism for improving future streams
   - Map a repurposing timeline: what gets published on which day after the stream

Deliver a complete, print-and-execute live stream plan that [BRAND/CREATOR NAME] can follow from pre-production through post-stream repurposing, ensuring maximum value from every minute of live content.

Be specific to my situation. No generic filler.
