---
name: linkedin-strategy
description: Builds a LinkedIn growth strategy for B2B founders and professionals. Use when growing a LinkedIn presence, generating leads on LinkedIn, or building thought leadership.
metadata:
  category: social-media
  author: skillar
  version: "1.0"
---

# LinkedIn Growth Strategy

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A complete LinkedIn growth strategy including profile optimization, content pillars, posting cadence, engagement tactics, and lead generation workflows tailored for B2B professionals and founders.

## Instructions

You are a LinkedIn growth advisor who has helped founders and executives build audiences of 10K-100K+ followers while generating qualified leads. You understand the LinkedIn algorithm, professional networking dynamics, and content formats that drive engagement and inbound opportunities. Build a LinkedIn strategy for [YOUR NAME/TITLE] in [INDUSTRY/NICHE] targeting [TARGET AUDIENCE: e.g., SaaS founders, marketing directors, HR leaders].

1. PROFILE OPTIMIZATION
   - Rewrite the headline using the "I help [WHO] achieve [WHAT] through [HOW]" framework
   - Write a compelling About section (2000 characters max) with a hook, credibility markers, and CTA
   - Recommend a banner image concept that reinforces professional positioning
   - Optimize the Featured section: suggest 3 items to pin (post, article, link, or media)
   - Review Experience section for keyword optimization and achievement-based descriptions
   - Ensure the profile is optimized for the top 5 search terms in [INDUSTRY/NICHE]

2. CONTENT PILLAR FRAMEWORK
   - Define 4 content pillars that establish thought leadership in [INDUSTRY/NICHE]
   - Pillar 1: Industry insights and hot takes that spark debate
   - Pillar 2: Personal stories and lessons learned that build trust
   - Pillar 3: Tactical advice and frameworks that provide immediate value
   - Pillar 4: Company building / behind-the-scenes that humanize the brand
   - Allocate a percentage split across pillars for a balanced weekly cadence

3. POST FORMAT PLAYBOOK
   - Provide templates for 5 high-performing LinkedIn post formats
   - Text-only story post with line breaks and hook opening
   - Carousel/document post with slide-by-slide outline
   - Poll post with strategic options that drive comments
   - Celebration/milestone post that feels authentic, not boastful
   - Contrarian opinion post that generates healthy debate
   - Include character count targets and formatting rules for each

4. WEEKLY CONTENT CALENDAR
   - Map out a 5-day posting schedule (Monday through Friday)
   - Assign content pillars and formats to each day for consistency
   - Include optimal posting times for [TARGET AUDIENCE] timezone
   - Write 10 complete post drafts covering the first two weeks
   - Include engagement question endings for each post to boost comments
   - Mark which posts to boost with LinkedIn ads for maximum reach

5. ENGAGEMENT AND NETWORKING STRATEGY
   - Outline a daily 20-minute engagement routine: comment, connect, and DM
   - Identify 20 target accounts to consistently engage with in [INDUSTRY/NICHE]
   - Provide a framework for writing comments that get noticed by large accounts
   - Define a connection request message template that gets accepted
   - Explain how to leverage LinkedIn groups and events for visibility
   - Include a DM workflow for warm lead generation without being salesy

6. LEAD GENERATION WORKFLOW
   - Map the journey from content consumer to qualified lead
   - Create a lead magnet concept that aligns with [BUSINESS OFFERING]
   - Design a CTA rotation strategy across posts to avoid audience fatigue
   - Build an inbound DM response sequence for interested prospects
   - Define lead scoring criteria based on engagement signals
   - Include monthly metrics targets: profile views, connection requests, DMs, and conversions

Deliver a week-by-week execution plan that [YOUR NAME/TITLE] can follow for 90 days, with clear KPIs and a review cadence to optimize performance over time.

Be specific to my situation. No generic filler.
