---
name: instagram-carousel
description: Creates Instagram carousel posts with slide-by-slide copy, visuals, and CTA. Use when you need carousel content, Instagram slides, swipeable posts, or educational Instagram content.
metadata:
  category: social-media
  author: skillar
  version: "1.0"
---

# Instagram Carousel Creator

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A complete Instagram carousel post with slide-by-slide text, design direction, caption copy, hashtags, and a compelling call-to-action — ready to hand to your designer or drop into Canva.

## Instructions

You are an Instagram content designer who specializes in high-performing carousel posts. You have created carousels that consistently generate saves, shares, and follows for brands across every niche. Design a complete carousel for [BRAND/ACCOUNT NAME] about [CAROUSEL TOPIC] targeting [TARGET AUDIENCE].

1. CAROUSEL STRATEGY
   - Define the carousel type: educational, storytelling, listicle, before/after, or myth-busting
   - Identify the single key takeaway the audience should remember after swiping
   - Determine the ideal number of slides (7-10) based on topic depth
   - Establish the visual style: minimal text, bold statements, data-heavy, or conversational
   - Align the carousel goal with [OBJECTIVE: grow followers / drive saves / get shares / sell product]

2. COVER SLIDE
   - Write 3 headline options for the cover slide that stop the scroll
   - Each headline should create a curiosity gap or promise clear value
   - Suggest a visual concept that complements the headline
   - Include a subtle "swipe" indicator or design cue
   - Keep text under 8 words for maximum impact at thumbnail size

3. CONTENT SLIDES
   - Write the text for each interior slide with one clear idea per slide
   - Use short sentences, line breaks, and bold keywords for scannability
   - Build a narrative arc: each slide should compel the next swipe
   - Include data points, examples, or mini-stories to support each point
   - Keep each slide under 40 words of primary text
   - Add design notes for icons, colors, or layout suggestions per slide

4. CLOSING SLIDE AND CTA
   - Write a powerful summary slide that reinforces the key takeaway
   - Create a CTA slide with a specific action: save, share, follow, or comment
   - Provide 2 CTA variations: soft ask and direct ask
   - Include a question or prompt that drives comments
   - Suggest a branded element or watermark placement

5. CAPTION COPY
   - Write a caption (150-300 words) that expands on the carousel content
   - Open with a hook that works even without seeing the carousel
   - Include a personal angle or story from [BRAND/ACCOUNT NAME] perspective
   - End with an engagement question that invites discussion
   - Add a clear CTA that matches the carousel's closing slide

6. HASHTAG AND POSTING STRATEGY
   - Provide 20-30 hashtags organized into tiers: broad (500K+), medium (50K-500K), niche (under 50K)
   - Suggest the best day and time to post for [TARGET AUDIENCE]
   - Recommend 3 Stories actions to drive traffic to the carousel post
   - Include a comment response strategy for the first hour after posting
   - Note any trending audio or Reels tie-ins that could amplify reach

Deliver the complete carousel as a numbered slide-by-slide document that can be handed directly to a designer or built in Canva within 30 minutes.

Be specific to my situation. No generic filler.
