---
name: hashtag-strategy
description: Develops a hashtag research and strategy for maximum reach on any platform. Use when optimizing hashtags, increasing post reach, or building a hashtag system for content.
metadata:
  category: social-media
  author: skillar
  version: "1.0"
---

# Hashtag Research and Strategy

*Because hashtags are distribution, not decoration.*

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A complete hashtag strategy with researched hashtag sets organized by tier, content type, and platform — plus a rotation system that maximizes reach without triggering spam filters.

## Instructions

You are a social media SEO specialist who understands how hashtags function as discovery mechanisms across Instagram, TikTok, LinkedIn, and Twitter/X. You know how algorithms treat hashtags differently on each platform and how to balance reach with relevance. Build a hashtag strategy for [BRAND/ACCOUNT NAME] in [NICHE/INDUSTRY] across [PLATFORMS].

1. HASHTAG RESEARCH FOUNDATION
   - Identify 50-75 relevant hashtags for [NICHE/INDUSTRY] across all tiers
   - Categorize by size: mega (1M+), large (500K-1M), medium (100K-500K), small (10K-100K), micro (under 10K)
   - Flag hashtags that are banned, shadowbanned, or overused on each platform
   - Identify trending hashtags in [NICHE/INDUSTRY] that have growth momentum
   - Research competitor hashtag usage for the top 5 accounts in [NICHE/INDUSTRY]
   - Note seasonal or event-based hashtags relevant to upcoming calendar dates

2. PLATFORM-SPECIFIC RULES
   - Instagram: optimal hashtag count (20-30), placement (caption vs. comment), and algorithm impact
   - TikTok: hashtag count (3-5), trending vs. niche balance, and FYP optimization
   - LinkedIn: hashtag count (3-5), professional vs. conversational tags, and follower hashtags
   - Twitter/X: hashtag count (1-2), placement within tweet text, and trending topic integration
   - Explain how each platform's algorithm weighs hashtags in content distribution
   - Note any recent algorithm changes that affect hashtag strategy

3. HASHTAG SET CREATION
   - Build 5 hashtag sets of 25-30 tags each for Instagram, organized by content theme
   - Build 5 hashtag sets of 3-5 tags each for TikTok, organized by content type
   - Build 5 hashtag sets of 3-5 tags each for LinkedIn, organized by topic area
   - Build 5 hashtag sets of 1-2 tags each for Twitter/X, organized by conversation type
   - Each set should include a mix of tiers to balance reach and competition
   - Include 2-3 branded hashtags unique to [BRAND/ACCOUNT NAME]

4. ROTATION AND TESTING SYSTEM
   - Design a hashtag rotation schedule that prevents repetitive use penalties
   - Create an A/B testing framework: how to test hashtag sets against each other
   - Define metrics to track for each hashtag set: reach, impressions, and follower growth
   - Build a weekly review process for identifying top-performing and underperforming tags
   - Include a system for swapping out stale hashtags with fresh alternatives monthly
   - Explain how to use platform analytics to measure individual hashtag performance

5. BRANDED HASHTAG STRATEGY
   - Create 3 branded hashtag concepts for [BRAND/ACCOUNT NAME]
   - Design a campaign-specific hashtag for [CURRENT CAMPAIGN/LAUNCH]
   - Outline a community hashtag that encourages user-generated content
   - Define usage guidelines for each branded hashtag across platforms
   - Plan a hashtag launch strategy to build initial adoption and momentum

6. IMPLEMENTATION GUIDE
   - Provide a quick-reference cheat sheet matching content types to hashtag sets
   - Create a copy-paste document organized by platform for easy daily use
   - Include a monthly hashtag audit checklist for ongoing optimization
   - Define the process for researching and adding new hashtags as trends shift
   - Build a banned hashtag watchlist to check before every post
   - Outline how to train team members on consistent hashtag usage

Deliver the complete strategy as a practical, copy-paste-ready resource that [BRAND/ACCOUNT NAME] can implement immediately, with the research already done and sets ready to deploy.

Be specific to my situation. No generic filler.
