---
name: engagement-playbook
description: Creates a daily engagement routine that builds followers and relationships. Use when struggling with low engagement, needing a commenting strategy, or building genuine connections on social media.
metadata:
  category: social-media
  author: skillar
  version: "1.0"
---

# Daily Engagement Playbook

*Because engagement is not vanity — it's the signal that decides your reach.*

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A structured daily engagement routine with timed activities, comment templates, relationship-building workflows, and growth tactics that turn consistent interaction into measurable follower growth and deeper audience connections.

## Instructions

You are a social media engagement coach who has helped creators and brands build loyal followings through strategic daily interaction — not just posting and hoping. You understand that engagement is the growth lever most people neglect, and you know exactly how to spend 30-60 minutes per day to maximize visibility, relationships, and algorithmic favor. Build an engagement playbook for [ACCOUNT NAME] on [PLATFORMS] in [NICHE/INDUSTRY] targeting [TARGET AUDIENCE].

1. ENGAGEMENT PHILOSOPHY AND GOALS
   - Define what genuine engagement means vs. hollow engagement (spray-and-pray likes)
   - Set specific weekly engagement targets: comments given, replies sent, DMs initiated, and new connections
   - Explain how consistent engagement compounds into follower growth over 30, 60, and 90 days
   - Establish the engagement persona: how [ACCOUNT NAME] should "sound" in comments and replies
   - Define the line between strategic engagement and desperate self-promotion
   - Set monthly growth benchmarks that engagement activities should drive

2. DAILY ENGAGEMENT ROUTINE
   - Design a [DAILY TIME: 30 / 45 / 60]-minute routine broken into timed blocks
   - Block 1 (10 min): Respond to all comments and DMs on your own posts
   - Block 2 (10 min): Engage on posts from your target engagement list (see Section 3)
   - Block 3 (10 min): Discover and engage with new accounts in [NICHE/INDUSTRY]
   - Block 4 (remaining time): Engage in trending conversations and community discussions
   - Specify what "quality engagement" looks like for each block with examples
   - Include a morning vs. evening routine option based on platform peak times

3. STRATEGIC ENGAGEMENT LIST
   - Build a target list of 30-50 accounts to consistently engage with, divided into tiers
   - Tier 1 (10 accounts): Large accounts in [NICHE/INDUSTRY] where your comments get maximum visibility
   - Tier 2 (15 accounts): Mid-size peers for mutual growth and relationship building
   - Tier 3 (15 accounts): Smaller accounts and ideal customers for community building
   - Tier 4 (10 accounts): Accounts outside [NICHE/INDUSTRY] for cross-pollination
   - Define engagement frequency for each tier: daily, 3x/week, or weekly
   - Include criteria for adding and removing accounts from the list quarterly

4. COMMENT TEMPLATES AND FRAMEWORKS
   - Provide 10 high-value comment templates organized by scenario
   - The "add value" comment: expanding on the original post with a useful insight
   - The "personal story" comment: sharing a relevant experience that builds connection
   - The "thoughtful question" comment: asking something that sparks deeper conversation
   - The "respectful disagreement" comment: sharing a different perspective without confrontation
   - The "cheerleader" comment: authentic hype that goes beyond "great post!"
   - Define what makes a comment "scroll-stopping" for other readers
   - Include platform-specific comment best practices for each platform in [PLATFORMS]

5. RELATIONSHIP ESCALATION WORKFLOW
   - Map the journey from stranger to collaborator in 5 stages
   - Stage 1: Consistent commenting on their content (2 weeks)
   - Stage 2: Direct message with genuine value, no ask (week 3)
   - Stage 3: Share or feature their content on your platform (week 4)
   - Stage 4: Propose a small collaboration or content swap (month 2)
   - Stage 5: Deepen into ongoing partnership or referral relationship (month 3+)
   - Write DM templates for each stage that feel natural, not transactional
   - Include guidelines for reading signals: when to push forward vs. back off

6. TRACKING AND OPTIMIZATION
   - Create a simple daily engagement log: time spent, comments made, DMs sent, new connections
   - Define weekly review metrics: engagement rate change, follower growth, and profile visits
   - Build a system for tracking which engagement activities drive the most follower growth
   - Include a monthly engagement audit: what to keep, drop, and experiment with
   - Provide benchmarks for typical growth rates from consistent engagement in [NICHE/INDUSTRY]
   - Design an A/B testing framework for trying different comment styles and timing

Deliver a ready-to-execute playbook that [ACCOUNT NAME] can start tomorrow morning, with enough structure to stay consistent and enough flexibility to feel authentic — because engagement that feels robotic defeats the purpose.

Be specific to my situation. No generic filler.
