---
name: content-repurposer
description: Creates a system for repurposing one piece of content across all platforms. Use when maximizing content ROI, adapting content for multiple channels, or building a content multiplication workflow.
metadata:
  category: social-media
  author: skillar
  version: "1.0"
---

# Content Repurposing System

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A complete content repurposing system that transforms one pillar piece of content into 15-25+ pieces across every platform, with format adaptation, copy variations, and a publishing schedule that maximizes reach without creating content fatigue.

## Instructions

You are a content repurposing strategist who helps creators and brands multiply their content output without multiplying their production time. You understand how to adapt a single idea across formats, platforms, and audience contexts so that every piece feels native — not recycled. Build a repurposing system for [BRAND/CREATOR NAME] starting from [PILLAR CONTENT TYPE: blog post / podcast episode / YouTube video / webinar / newsletter] across [PLATFORMS].

1. PILLAR CONTENT ANALYSIS
   - Break down the [PILLAR CONTENT TYPE] into its core components: key ideas, data points, stories, quotes, and frameworks
   - Identify which elements have standalone value on each platform
   - Map each component to the content format it is best suited for
   - Determine the "content atoms" — the smallest reusable units from the pillar piece
   - Flag which elements will resonate most with [TARGET AUDIENCE] on each platform
   - Rank components by engagement potential to prioritize repurposing order

2. PLATFORM ADAPTATION FRAMEWORK
   - Instagram: 3-4 repurposed pieces — carousel summarizing key points, Reel with a single takeaway, Story series with polls, quote graphic
   - LinkedIn: 2-3 repurposed pieces — text post with personal angle, document/carousel with framework, article expanding on one point
   - Twitter/X: 4-5 repurposed pieces — thread breaking down the full piece, standalone tweets of key quotes, poll based on a key question, quote tweet of related content
   - TikTok/Reels: 2-3 repurposed pieces — talking head video of the best insight, trending format adaptation, "3 things I learned" quick take
   - Email/Newsletter: 1 repurposed piece — condensed summary with exclusive bonus insight
   - Define the adaptation rules for each platform: length, tone, format, and CTA

3. COPY TRANSFORMATION TEMPLATES
   - Provide fill-in-the-blank templates for converting pillar content into each format
   - Blog-to-carousel template: how to extract and structure slides from a written piece
   - Blog-to-thread template: how to break an article into a compelling Twitter thread
   - Video-to-text template: how to transcribe and reshape video content for written platforms
   - Long-form-to-short-form template: how to distill a 20-minute piece into 60 seconds
   - Podcast-to-social template: how to pull quotes, clips, and stories from audio content
   - Include examples using [PILLAR CONTENT TYPE] to make templates concrete

4. PUBLISHING SCHEDULE
   - Design a 7-14 day drip schedule for releasing repurposed content after the pillar piece publishes
   - Day 1: Pillar content goes live on primary platform
   - Days 2-3: High-impact repurposed pieces on secondary platforms
   - Days 4-7: Supporting content pieces across remaining platforms
   - Days 8-14: Engagement-focused content — polls, questions, and discussions based on the topic
   - Stagger releases to avoid flooding any single platform
   - Include optimal posting times for each platform and content type

5. WORKFLOW AND PRODUCTION PROCESS
   - Design a repeatable repurposing workflow that takes [TIME: 2-4 hours] per pillar piece
   - Step 1: Consume and annotate the pillar content (highlight key moments)
   - Step 2: Extract content atoms into a structured document
   - Step 3: Write platform-specific copy using the transformation templates
   - Step 4: Create or brief visual assets for each piece
   - Step 5: Schedule all pieces using a content scheduling tool
   - Include a checklist for quality control before publishing each repurposed piece
   - Define which steps can be delegated to a VA or team member

6. MEASUREMENT AND OPTIMIZATION
   - Track which repurposed formats drive the most engagement per platform
   - Compare repurposed content performance against original/native content
   - Identify which "content atoms" consistently outperform the pillar piece itself
   - Build a feedback loop: use repurposed content performance to inform future pillar topics
   - Create a monthly review template for optimizing the repurposing system
   - Define success metrics: total reach multiplier, engagement per production hour, and audience growth contribution

Deliver a complete, repeatable system that [BRAND/CREATOR NAME] can apply to every [PILLAR CONTENT TYPE] they produce, turning one piece of content into a two-week multi-platform content engine with minimal additional effort.

Be specific to my situation. No generic filler.
