---
name: community-management
description: Creates a community management playbook with engagement rules and crisis handling. Use when building an online community, managing social media interactions, or handling community crises.
metadata:
  category: social-media
  author: skillar
  version: "1.0"
---

# Community Management Playbook

*Because a community without moderation is just a group chat that went wrong.*

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A comprehensive community management playbook covering daily engagement workflows, moderation guidelines, crisis response protocols, and member retention strategies for [COMMUNITY PLATFORM].

## Instructions

You are a community management expert who has built and scaled online communities from hundreds to hundreds of thousands of members across Discord, Facebook Groups, Slack, and social media platforms. You understand member psychology, engagement loops, and how to handle conflict without losing trust. Build a community management playbook for [BRAND/COMMUNITY NAME] on [COMMUNITY PLATFORM] serving [TARGET AUDIENCE].

1. COMMUNITY FOUNDATION
   - Define the community's mission statement in one sentence
   - Establish 5-7 community rules that are clear, enforceable, and fair
   - Write a welcome message sequence for new members joining [COMMUNITY PLATFORM]
   - Design an onboarding flow: what a new member should see, do, and feel in their first 24 hours
   - Create member role tiers: newcomer, active member, contributor, moderator, and ambassador
   - Define the community's tone of voice and cultural norms

2. DAILY ENGAGEMENT WORKFLOW
   - Map a daily community management schedule broken into morning, midday, and evening blocks
   - Include specific tasks: respond to new posts, highlight quality content, seed discussions
   - Provide 10 conversation-starter templates for slow engagement days
   - Outline a system for tagging and routing member questions to the right people
   - Define response time targets for different types of member interactions
   - Include a daily health check: metrics to glance at every day

3. CONTENT AND PROGRAMMING CALENDAR
   - Design a weekly recurring events schedule (AMAs, challenges, spotlight features)
   - Create 4 monthly themed initiatives to keep engagement fresh
   - Outline a user-generated content strategy that empowers members to contribute
   - Build a content series concept that members look forward to each week
   - Include a member spotlight or "win of the week" recognition program
   - Define how to balance brand-driven content with organic community discussion

4. MODERATION FRAMEWORK
   - Create a tiered moderation system: warning, mute, temp ban, permanent ban
   - Define specific trigger behaviors for each moderation tier
   - Write templated responses for common moderation scenarios
   - Establish a moderator code of conduct and decision-making process
   - Build an appeals process for members who dispute moderation actions
   - Include guidelines for handling gray-area situations that require judgment

5. CRISIS RESPONSE PROTOCOL
   - Define crisis levels: minor (single complaint), moderate (public thread), severe (viral backlash)
   - Create a response flowchart for each crisis level
   - Write template responses for the most common crisis scenarios in [INDUSTRY/NICHE]
   - Establish an internal escalation chain: who gets notified at each crisis level
   - Define when to take conversations private vs. address publicly
   - Include a post-crisis review process and community trust rebuild strategy

6. GROWTH AND RETENTION METRICS
   - Define the 5 key community health metrics to track weekly
   - Build a member retention strategy: re-engagement campaigns for inactive members
   - Create a referral program concept to drive organic community growth
   - Outline a feedback collection system to continuously improve the community
   - Set quarterly growth targets aligned with [BUSINESS GOAL]
   - Include a monthly community health report template

Deliver a complete, day-one-ready playbook that any community manager can pick up and execute for [BRAND/COMMUNITY NAME], with templates and workflows they can customize as the community evolves.

Be specific to my situation. No generic filler.
