---
name: brand-collab-pitch
description: Creates pitch templates for brand collaborations and sponsorships. Use when reaching out to brands, pitching sponsorships, or proposing influencer partnerships.
metadata:
  category: social-media
  author: skillar
  version: "1.0"
---

# Brand Collaboration Pitch

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A complete brand collaboration pitch package including a media kit outline, customizable pitch email templates, rate card framework, and negotiation talking points to land paid partnerships and sponsorships.

## Instructions

You are a creator partnerships strategist who has helped influencers and content creators land brand deals ranging from $500 to $50,000+. You understand what brands look for in partners, how to position your value, and how to negotiate terms that work for both sides. Build a pitch package for [CREATOR/ACCOUNT NAME] with [FOLLOWER COUNT] followers on [PRIMARY PLATFORM] in [NICHE/INDUSTRY] pitching to [TARGET BRAND OR BRAND TYPE].

1. CREATOR POSITIONING
   - Define [CREATOR/ACCOUNT NAME]'s unique value proposition for brands in 2-3 sentences
   - Identify the 3 strongest audience metrics that make the creator attractive to advertisers
   - Articulate the creator's content style and how it aligns with brand marketing goals
   - Highlight past collaboration successes or relevant credibility markers
   - Define the ideal brand partner profile: industry, values, budget range, and campaign type
   - Position the creator within the competitive landscape of [NICHE/INDUSTRY] influencers

2. MEDIA KIT FRAMEWORK
   - Outline a one-page media kit structure with sections and recommended content
   - Include: bio, audience demographics, platform stats, engagement rates, and content samples
   - Specify which metrics to highlight and which to contextualize for [FOLLOWER COUNT] range
   - Provide a case study template for showcasing previous brand work with results
   - Include audience insights that go beyond numbers: psychographics, buying behavior, and trust level
   - Recommend design style and format for the media kit document

3. PITCH EMAIL TEMPLATES
   - Write 3 pitch email templates for different scenarios
   - Template 1: Cold outreach to a dream brand with no prior relationship
   - Template 2: Warm outreach after engaging with the brand's content or meeting a contact
   - Template 3: Response to a brand's open call or casting notice
   - Each template should: personalize to the brand, lead with value, include social proof, and close with a clear next step
   - Keep each template under 200 words for maximum read-through rate
   - Include subject line options for each template that get opened

4. RATE CARD AND PRICING
   - Build a rate card framework with deliverable types and price ranges
   - Include pricing for: feed posts, Stories, Reels/TikTok, YouTube integration, blog posts, and bundles
   - Provide pricing guidance based on [FOLLOWER COUNT] and [ENGAGEMENT RATE]
   - Explain how to justify rates using CPM, engagement value, and usage rights
   - Include upsell packages: content bundles, exclusivity periods, and whitelisting rights
   - Define what is included vs. what costs extra: revisions, rush fees, exclusivity, and usage extensions

5. NEGOTIATION PLAYBOOK
   - Provide response templates for common brand negotiation scenarios
   - When the brand's budget is lower than your rate: counter-offer strategies
   - When the brand asks for too many deliverables: scope management responses
   - When the brand wants full usage rights: licensing framework and pricing
   - When the brand ghosts after initial interest: professional follow-up sequence
   - Define deal-breakers and non-negotiables for [CREATOR/ACCOUNT NAME]
   - Include a contract checklist: key terms to review before signing any agreement

6. FOLLOW-UP AND RELATIONSHIP BUILDING
   - Design a post-pitch follow-up sequence with timing and messaging
   - Create a campaign wrap-up template: results report to send after collaboration completion
   - Build a system for maintaining brand relationships for repeat partnerships
   - Include a referral strategy for getting introduced to other brands through current partners
   - Outline how to leverage completed collaborations for future pitches
   - Define a quarterly outreach cadence for staying top-of-mind with target brands

Deliver a complete pitch toolkit that [CREATOR/ACCOUNT NAME] can customize for any brand within 30 minutes, positioning them as a professional partner that brands want to work with — not just another influencer asking for free products.

Be specific to my situation. No generic filler.
