---
name: tiktok-ad-script
description: Writes a TikTok ad script that feels native and converts. Use when creating TikTok ads, scripting short-form video ads, planning Spark Ads, or producing UGC-style ad content.
metadata:
  category: ads-paid-media
  author: skillar
  version: "1.0"
---

# TikTok Ad Script Writer

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A scroll-stopping TikTok ad script with a hook, narrative arc, and call-to-action designed to feel native to the platform. Includes shot-by-shot direction, on-screen text overlay cues, and sound recommendations.

## Instructions

You are a TikTok creative strategist who has produced hundreds of viral paid ads on the platform. You understand that TikTok ads must feel like content, not commercials — the best-performing ads are indistinguishable from organic posts in the first three seconds.

Write a TikTok ad script for [BUSINESS/BRAND NAME] promoting [PRODUCT/SERVICE/OFFER]. The target audience is [TARGET AUDIENCE — age, interests, pain points]. The ad objective is [PURCHASES, APP INSTALLS, LEADS, TRAFFIC]. The key selling points are [TOP 3 BENEFITS OR FEATURES]. The tone should be [TONE — e.g., casual and funny, authentic and relatable, edgy and bold].

1. HOOK STRATEGY (FIRST 1-3 SECONDS)
   - Write 5 alternative hook options that stop the scroll instantly
   - Use pattern interrupts: a bold claim, a question, a visual surprise, or a relatable frustration
   - Specify the exact on-screen text overlay for each hook (large, readable, high-contrast)
   - Indicate whether the hook should be spoken, text-only, or a combination
   - Note the camera angle and framing for maximum immediate engagement

2. SCRIPT BODY (SECONDS 3-20)
   - Write the full spoken script word-for-word with timing markers every 3-5 seconds
   - Keep the language conversational — contractions, slang where appropriate, no corporate speak
   - Structure the narrative using one of these frameworks: problem-solution, before-after, storytime, or day-in-my-life
   - Include a natural product reveal or demonstration moment that feels unforced
   - Add 2-3 on-screen text callouts that reinforce key points for sound-off viewers
   - Specify any visual transitions, cuts, or B-roll inserts between spoken segments

3. CALL TO ACTION (FINAL 3-5 SECONDS)
   - Write a clear, urgent CTA that matches TikTok's native tone (not salesy)
   - Specify the on-screen text and any pointing or gesture cues
   - Include the CTA button text recommendation for TikTok Ads Manager
   - Provide an alternative soft CTA for retargeting audiences who need less urgency
   - Note whether a comment-pinning strategy or bio link mention should supplement the CTA

4. PRODUCTION DIRECTION
   - Specify the ideal creator type (founder, customer, influencer, actor) and why
   - Detail the filming environment (at home, outside, office, on-the-go) for authenticity
   - Recommend lighting and camera setup (phone selfie, tripod, ring light) to match native feel
   - List any props, product packaging, or visual elements needed on screen
   - Suggest a trending sound or original audio approach with specific guidance
   - Include aspect ratio (9:16), resolution, and length variations to produce (15s, 30s, 60s)

5. VARIANT SCRIPTS
   - Write 2 additional complete script variations using different hook styles and narrative angles
   - Create one version optimized for Spark Ads (boosted organic post feel)
   - Create one version designed as a creator/influencer partnership brief
   - Note which variant to test first based on current TikTok ad trends
   - Specify the audience split for testing each variant

Format each script with clear shot numbers, timing markers, spoken dialogue in quotes, and production notes in brackets. The scripts should be ready to hand to a creator or internal team for same-day filming.

Be specific to my situation. No generic filler.
