---
name: landing-page-for-ads
description: Designs a landing page optimized for paid traffic with message match. Use when building landing pages for ads, improving ad-to-page conversion, reducing bounce rate on paid traffic, or launching campaign-specific pages.
metadata:
  category: ads-paid-media
  author: skillar
  version: "1.0"
---

# Ad Landing Page Builder

*Because sending paid traffic to your homepage is burning money.*

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A complete landing page blueprint optimized for paid traffic, including headline and copy for every section, message match alignment with your ad, layout wireframe, trust elements, and CTA strategy designed to maximize the conversion rate from your ad spend.

## Instructions

You are a conversion rate optimization specialist who builds landing pages specifically for paid media campaigns. You understand that the landing page is where ad spend either turns into revenue or gets wasted. Every element on the page must reinforce the promise made in the ad and remove friction from the conversion path.

Design a landing page for [BUSINESS/BRAND NAME] that will receive traffic from [AD PLATFORM AND CAMPAIGN TYPE — e.g., Google Search ads for "project management software"]. The ad promises [WHAT THE AD SAYS OR OFFERS]. The desired conversion action is [FORM FILL, PURCHASE, DEMO REQUEST, SIGN UP, DOWNLOAD]. The target audience is [AUDIENCE DESCRIPTION]. The product or offer is [PRODUCT/SERVICE DETAILS].

1. MESSAGE MATCH AND HERO SECTION
   - Write the hero headline that directly mirrors the ad copy the visitor just clicked
   - Write a sub-headline that expands on the headline with a specific benefit or outcome
   - Define the hero image or video concept that visually reinforces the headline promise
   - Place the primary CTA button with specific button text (action-oriented, first person)
   - Include a trust indicator immediately visible above the fold (logos, rating, user count)
   - Specify the exact layout of the above-the-fold section with element positioning

2. PROBLEM AND SOLUTION NARRATIVE
   - Write a problem agitation section that names the visitor's pain point in their own language
   - Transition to the solution with 3-4 key benefits written as outcomes, not features
   - Use bullet points or icon blocks for scannable benefit presentation
   - Include a supporting image, screenshot, or demo GIF for each major benefit
   - Keep copy concise — every sentence must earn its place on the page

3. SOCIAL PROOF SECTION
   - Specify the types of social proof to include (testimonials, case studies, logos, stats, reviews)
   - Write 2-3 testimonial templates with the structure: situation, action, result
   - Include specific numbers and outcomes in proof elements (not vague praise)
   - Recommend placement of star ratings, review counts, or trust badges
   - Add a case study snippet with a measurable before-and-after result
   - Position social proof strategically between the problem section and the final CTA

4. CONVERSION ELEMENTS
   - Design the primary conversion form with exact field labels (minimize fields to essentials)
   - Write the CTA button text for primary and any secondary conversion points
   - Add micro-copy near the CTA to reduce anxiety (privacy assurance, no credit card, free trial terms)
   - Include a secondary CTA for visitors not ready to convert (watch demo, read case study)
   - Define the sticky header or floating CTA behavior for long-scroll pages
   - Specify the thank-you page content and next-step instructions post-conversion

5. PAGE STRUCTURE AND UX
   - Outline the full section order from top to bottom with section purposes
   - Specify navigation approach (no nav bar to prevent exit, or minimal focused nav)
   - Define mobile layout adaptations for every section
   - Set page speed requirements and recommend image optimization approach
   - Include an FAQ section with 4-6 objection-handling questions and answers
   - Ensure the page can be fully consumed in under 3 minutes of scrolling

6. TRACKING AND TESTING
   - List all tracking pixels and tags to install (Google Ads, Meta Pixel, analytics)
   - Define the conversion event to fire on form submission or purchase
   - Recommend the first 3 A/B tests to run (headline, CTA, hero image, form length)
   - Set up UTM parameter handling to preserve attribution from ad to conversion
   - Specify heatmap and session recording setup for post-launch optimization

Deliver the landing page as a complete content wireframe with all copy written, section-by-section layout guidance, and implementation notes that a web developer or page builder user can execute without additional briefing.

Be specific to my situation. No generic filler.
