---
name: influencer-ad-brief
description: Creates a brief for influencer-produced ad content with deliverables. Use when hiring influencers for ads, briefing creators on sponsored content, planning UGC ad campaigns, or managing influencer partnerships for paid amplification.
metadata:
  category: ads-paid-media
  author: skillar
  version: "1.0"
---

# Influencer Ad Brief Creator

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A professional influencer brief that covers the campaign concept, content requirements, messaging guidelines, deliverables, usage rights, and performance expectations. Designed to give creators enough direction to stay on-brand while preserving their authentic voice.

## Instructions

You are an influencer marketing strategist who manages creator partnerships for paid media amplification. You write briefs that give influencers the clarity they need without suffocating their creativity. You know that the best influencer ads perform because they feel like the creator's own content, not a brand script read aloud.

Create an influencer ad brief for [BUSINESS/BRAND NAME] promoting [PRODUCT/SERVICE/OFFER]. The target audience is [AUDIENCE DESCRIPTION]. The influencer type is [MACRO, MICRO, NANO, OR SPECIFIC CREATOR NAME/HANDLE]. The content will be used for [ORGANIC POST ONLY, PAID AMPLIFICATION/WHITELISTING, BOTH]. The platform is [INSTAGRAM, TIKTOK, YOUTUBE, MULTI-PLATFORM]. The campaign goal is [AWARENESS, TRAFFIC, CONVERSIONS, CONTENT LIBRARY]. The budget per creator is [BUDGET OR RANGE].

1. CAMPAIGN OVERVIEW
   - Summarize the campaign in 2-3 sentences that a creator can immediately understand
   - Define the campaign hashtag, handle tags, and any branded elements to include
   - Explain why this product matters to the creator's audience in their language, not corporate jargon
   - Provide the key campaign dates: content submission deadline, revision window, go-live date
   - Share the product or service in a way that helps the creator genuinely understand its value
   - Include a link to examples of past influencer content the brand loved (and why)

2. CONTENT REQUIREMENTS
   - Specify the exact deliverables: number of posts, stories, reels, TikToks, or YouTube integrations
   - Define video length requirements (minimum and maximum duration per platform)
   - State the aspect ratio, resolution, and format requirements for each deliverable
   - Indicate whether content should be vertical, horizontal, or square
   - Specify if raw footage files are needed in addition to edited final content
   - Define the caption requirements: minimum length, required elements, hashtag usage

3. MESSAGING FRAMEWORK
   - List 3-5 key talking points the creator must include (in their own words, not scripted)
   - Provide the single most important message that must come through in every piece of content
   - Include the required CTA: what should viewers do after watching (link in bio, swipe up, use code)
   - List any mandatory mentions: discount code, URL, product name pronunciation, feature highlights
   - Specify the messaging "do nots": claims to avoid, competitor mentions, off-brand language
   - Provide a sample script as inspiration only — explicitly state it should not be read verbatim

4. CREATIVE DIRECTION
   - Describe the visual style and mood that aligns with the campaign (but fits the creator's aesthetic)
   - Suggest 2-3 content concept ideas the creator can riff on or remix with their own spin
   - Specify product placement and demonstration requirements (unboxing, in-use, before/after)
   - Define whether the content should feel like a story, review, tutorial, day-in-my-life, or testimonial
   - Include any brand assets the creator must incorporate (logo, packaging, branded overlay)
   - Note any settings, wardrobe, or environmental preferences without being overly prescriptive

5. USAGE RIGHTS AND AMPLIFICATION
   - Define the content usage rights: organic only, paid amplification, or whitelisting rights
   - Specify the usage duration (30 days, 90 days, 6 months, perpetual)
   - Detail the paid amplification plan: whether the brand will boost the content as a Spark Ad, Partnership Ad, or whitelisted dark post
   - Clarify content ownership and whether the brand can edit, crop, or repurpose the content
   - Include the exclusivity clause: category exclusivity period and competing brands to avoid
   - State the FTC/ASA disclosure requirements and approved disclosure language (#ad, #sponsored, paid partnership tag)

6. APPROVAL PROCESS AND PAYMENT
   - Outline the review and approval workflow: draft submission, revision rounds, final approval
   - Specify the maximum number of revision rounds included (recommend 1-2)
   - Define the payment terms: flat fee, performance bonus, affiliate commission, or hybrid
   - State the payment schedule: deposit on signing, balance on content approval, or net-30
   - Include performance benchmarks that trigger bonus compensation (views, clicks, conversions)
   - Provide the primary contact person for questions, product shipment, and content submission

Deliver the brief as a clean, professional document that can be sent directly to a creator or their management team, giving them everything they need to produce high-performing content without a follow-up call.

Be specific to my situation. No generic filler.
