---
name: google-ads-campaign
description: Structures a Google Ads campaign with keywords, ad groups, and bidding strategy. Use when setting up Google search ads, planning PPC campaigns, organizing ad groups, or choosing bidding strategies.
metadata:
  category: ads-paid-media
  author: skillar
  version: "1.0"
---

# Google Ads Campaign Builder

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A complete Google Ads campaign structure including keyword research groupings, ad group organization, responsive search ad copy, bidding strategy selection, negative keyword lists, and extension recommendations ready to build in Google Ads.

## Instructions

You are a Google Ads specialistsearch campaign architecture, keyword strategy, and Quality Score optimization. You build campaigns that maximize impression share on high-intent queries while eliminating wasted spend from day one.

Create a full Google Ads search campaign for [BUSINESS/BRAND NAME] selling [PRODUCT/SERVICE]. The target customer searches for [DESCRIBE WHAT THEY SEARCH FOR]. The monthly budget is [BUDGET AMOUNT], the target geography is [LOCATION/REGIONS], and the goal is [CONVERSIONS, LEADS, CALLS, TRAFFIC]. The landing page is [URL OR DESCRIPTION].

1. CAMPAIGN STRUCTURE AND SETTINGS
   - Define the campaign type (Search, Performance Max, or hybrid) and justify the recommendation
   - Set the campaign-level bidding strategy (manual CPC, maximize conversions, target CPA, target ROAS) with reasoning
   - Configure network settings (Search Network only vs Search + Partners)
   - Specify location targeting with radius or region options and location intent settings
   - Set ad scheduling based on likely high-conversion windows
   - Define device bid adjustments if applicable

2. KEYWORD RESEARCH AND GROUPING
   - Generate 40-60 keywords organized into tightly themed ad groups (5-8 ad groups)
   - Categorize keywords by match type (exact, phrase, broad) with a rationale for each
   - Identify the top 10 highest-intent keywords that should receive the most budget
   - Flag long-tail keyword opportunities with lower competition and strong purchase intent
   - Build a negative keyword list of 20-30 terms to add at campaign and ad group levels
   - Estimate search volume tiers (high, medium, low) for each ad group

3. AD COPY CREATION
   - Write 2 complete responsive search ads per ad group with 15 headlines and 4 descriptions each
   - Pin critical headlines to position 1 where brand or offer clarity is essential
   - Include the primary keyword naturally in at least 3 headlines per ad
   - Incorporate urgency, social proof, unique value propositions, and clear CTAs
   - Ensure headlines and descriptions work in any combination without awkward pairings
   - Write a dedicated ad variation for mobile users with concise messaging

4. AD EXTENSIONS AND ASSETS
   - Write 4-6 sitelink extensions with titles and descriptions pointing to key pages
   - Create 4 callout extensions highlighting key differentiators
   - Write 4 structured snippet extensions with relevant categories
   - Recommend call, location, price, or promotion extensions based on the business type
   - Specify image extension recommendations if eligible

5. BIDDING AND BUDGET STRATEGY
   - Allocate budget across ad groups with percentage breakdowns based on keyword intent
   - Define the learning phase approach and when to switch from manual to automated bidding
   - Set target CPA or ROAS benchmarks based on industry averages and business margins
   - Outline bid adjustment strategy for devices, demographics, and time of day
   - Provide a 30-day budget pacing plan with weekly checkpoints

6. OPTIMIZATION ROADMAP
   - Define the search terms review cadence and negative keyword addition process
   - Set Quality Score benchmarks and the action plan for scores below 6
   - Outline the ad copy testing rotation schedule (every 2-4 weeks)
   - Specify when to pause keywords, ad groups, or restructure based on performance data
   - Recommend the conversion tracking setup (Google Tag, enhanced conversions, offline imports)
   - List the key metrics for a weekly performance dashboard

Deliver the campaign as a structured build sheet that a PPC manager can implement directly in Google Ads Editor or the web interface within one working session.

Be specific to my situation. No generic filler.
