---
name: conversion-tracking-setup
description: Sets up conversion tracking across platforms with attribution. Use when implementing tracking pixels, fixing broken conversion data, setting up Meta CAPI, configuring Google Ads conversions, or aligning attribution across channels.
metadata:
  category: ads-paid-media
  author: skillar
  version: "1.0"
---

# Conversion Tracking Setup Guide

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A complete conversion tracking implementation plan covering pixel installation, event configuration, server-side tracking, attribution settings, and cross-platform measurement alignment so every conversion is accurately captured and attributed.

## Instructions

You are a marketing technology specialist focused on conversion tracking and measurement. You have debugged hundreds of broken tracking setups and know that bad data leads to bad decisions which leads to wasted budget. You ensure every dollar of ad spend can be traced to its outcome with maximum accuracy.

Create a conversion tracking setup plan for [BUSINESS/BRAND NAME] with a [WEBSITE PLATFORM — Shopify, WordPress, custom, etc.] website. The ad platforms in use are [PLATFORMS — Meta, Google Ads, TikTok, LinkedIn, etc.]. The key conversion events are [LIST EVENTS — purchase, lead form submission, sign-up, add to cart, phone call, app install]. The current tracking status is [DESCRIBE — no tracking, partial setup, tracking seems broken, data discrepancies]. The website URL is [URL].

1. TRACKING ARCHITECTURE
   - Map every user action from ad click to final conversion as a complete event flow
   - Define the primary conversion event and all micro-conversion events to track
   - Assign event values to each conversion type (static or dynamic based on purchase amount)
   - Specify the data layer structure needed for clean event passing
   - Determine whether to use a tag manager (GTM) or direct platform code installation
   - Diagram the tracking stack: ad platforms, analytics, CRM, and how data flows between them

2. PIXEL AND TAG INSTALLATION
   - Provide step-by-step installation instructions for each platform's base pixel/tag
   - Specify the exact placement (header vs body, all pages vs specific pages)
   - Configure Meta Pixel with standard events: PageView, ViewContent, AddToCart, InitiateCheckout, Purchase, Lead
   - Configure Google Ads conversion tags with the global site tag and event snippets
   - Set up TikTok Pixel and LinkedIn Insight Tag with their respective event configurations
   - Include the Google Tag Manager container setup with trigger and tag configurations for each event

3. SERVER-SIDE TRACKING
   - Design the Meta Conversions API (CAPI) implementation for reliable server-side event delivery
   - Configure Google Ads enhanced conversions with first-party data matching
   - Set up event deduplication between browser pixel and server-side events to prevent double counting
   - Specify the user data parameters to pass for improved match rates (email, phone, address hashing)
   - Recommend the implementation method: direct API integration, partner integration, or gateway
   - Define the testing protocol to verify server events are firing and matching correctly

4. ATTRIBUTION CONFIGURATION
   - Set the attribution window for each platform aligned with the actual buying cycle
   - Configure Meta attribution: 7-day click, 1-day view (or custom window with justification)
   - Configure Google Ads attribution model: data-driven, last-click, or position-based with reasoning
   - Align attribution windows across platforms to enable fair cross-channel comparison
   - Set up Google Analytics 4 as the source of truth for cross-channel attribution
   - Define the rules for handling attribution overlap when multiple platforms claim the same conversion

5. TESTING AND VALIDATION
   - Create a testing checklist for every conversion event on every platform
   - Use Meta Events Manager, Google Tag Assistant, and platform debuggers to verify event fires
   - Test the complete funnel from ad click through conversion on desktop and mobile
   - Verify that conversion values, currency, and event parameters pass correctly
   - Check for common issues: duplicate events, missing events on redirect pages, cross-domain tracking gaps
   - Set up real-time monitoring alerts for tracking failures (zero conversions for 24 hours)

6. REPORTING AND MAINTENANCE
   - Build a cross-platform reporting framework that accounts for attribution differences
   - Define the single source of truth for conversion counting and how to reconcile platform discrepancies
   - Set up automated data pipelines if budget allows (platform APIs to spreadsheet or dashboard)
   - Create a monthly tracking health check process to catch drift and breakage
   - Document the entire tracking setup for team reference and future troubleshooting
   - Specify the privacy compliance requirements (cookie consent, GDPR, iOS ATT) and their tracking impact

Deliver the setup plan as a technical implementation guide that a developer, marketing ops person, or technically-capable marketer can follow step by step to achieve complete, accurate conversion tracking within one week.

Be specific to my situation. No generic filler.
