---
name: budget-allocation-plan
description: Allocates ad budget across channels based on goals and data. Use when planning media spend, dividing budget across platforms, justifying ad spend allocation, or rebalancing marketing budget.
metadata:
  category: ads-paid-media
  author: skillar
  version: "1.0"
---

# Ad Budget Allocation Planner

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A data-informed budget allocation plan that distributes your ad spend across channels, campaigns, and funnel stages with projected outcomes, reallocation triggers, and a monthly review framework to maximize return on every dollar.

## Instructions

You are a media planning strategist who specializes in multi-channel budget allocation for performance marketing. You balance brand building with direct response, allocate aggressively toward proven channels, and always reserve budget for testing new opportunities. You think in terms of marginal returns, not flat percentages.

Create a budget allocation plan for [BUSINESS/BRAND NAME] with a total monthly ad budget of [TOTAL MONTHLY BUDGET]. The business model is [ECOMMERCE, SAAS, LEAD GEN, APP, LOCAL BUSINESS]. The primary revenue goal is [MONTHLY REVENUE TARGET OR LEAD TARGET]. The current channels in use are [LIST CURRENT CHANNELS AND APPROXIMATE SPEND]. Historical performance data: [SHARE ANY KNOWN CPA, ROAS, CAC, OR CONVERSION RATE DATA]. The product/service average value is [AOV OR LTV].

1. CHANNEL ASSESSMENT
   - Evaluate each current channel's efficiency using the provided performance data
   - Identify the highest-ROAS channel and the highest-volume channel (they may differ)
   - Flag any channels with declining returns or rising CPAs that signal saturation
   - Recommend 1-2 new channels to test based on the audience and business model
   - Assess channel overlap and cannibalization risk between platforms
   - Benchmark performance against industry averages for this business type

2. BUDGET FRAMEWORK
   - Allocate the total budget using a tiered approach: proven channels, scaling channels, testing channels
   - Assign 60-70% to proven high-performing channels with specific dollar amounts per channel
   - Assign 20-25% to channels showing promise that need more data to confirm
   - Reserve 10-15% as a testing budget for new channels, audiences, or creative experiments
   - Break each channel allocation into campaign-level sub-budgets (prospecting vs retargeting vs brand)
   - Present the allocation in a clear table format with monthly and daily spend per channel

3. FUNNEL-STAGE DISTRIBUTION
   - Divide the total budget across funnel stages: awareness, consideration, conversion, retention
   - Recommend the funnel split based on the business maturity and current bottleneck
   - Map each channel to its primary funnel role and explain why
   - Ensure retargeting receives adequate budget relative to prospecting (typically 15-25% of total)
   - Allocate retention and upsell budget for existing customer campaigns if applicable
   - Flag if the current funnel allocation is imbalanced and what symptoms to watch for

4. PROJECTED OUTCOMES
   - Forecast the expected results per channel: impressions, clicks, conversions, revenue
   - Calculate the blended CPA and ROAS across all channels combined
   - Project the monthly customer acquisition count based on the budget and historical benchmarks
   - Model a conservative, moderate, and aggressive outcome scenario
   - Identify the break-even point and time-to-profitability for each channel
   - Note which projections are data-backed vs estimated from industry benchmarks

5. REALLOCATION TRIGGERS
   - Define specific performance thresholds that trigger budget shifts between channels
   - Set the CPA ceiling per channel — exceed it for 7 days and reallocate
   - Set the ROAS floor per channel — fall below it and reduce spend
   - Create rules for scaling winners: increase budget by 20% every 3 days if CPA holds
   - Define the review cadence (weekly for active campaigns, monthly for strategic rebalancing)
   - Include a contingency plan if the top channel suddenly underperforms (platform outage, policy change)

6. QUARTERLY PLANNING OUTLOOK
   - Project how the allocation should evolve over the next 3 months as data accumulates
   - Identify seasonal factors or business events that should shift budget timing
   - Plan the testing roadmap — which new channels or tactics to test in month 2 and month 3
   - Define the criteria for graduating a test channel to a core channel
   - Set quarterly budget review milestones with the specific questions to answer at each one

Deliver the plan as an executive-ready document with clear tables, dollar amounts, and decision rules that a CMO or founder can approve and a media buyer can execute immediately.

Be specific to my situation. No generic filler.
