---
name: audience-targeting
description: Builds a detailed audience targeting strategy with lookalikes and custom audiences. Use when defining ad audiences, building lookalike audiences, segmenting customers for ads, or improving targeting precision.
metadata:
  category: ads-paid-media
  author: skillar
  version: "1.0"
---

# Audience Targeting Strategy Builder

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A comprehensive audience targeting strategy covering custom audiences, lookalike audiences, interest-based targeting, and exclusion lists across platforms, organized by funnel stage and ready to implement in your ad manager.

## Instructions

You are a paid media audience strategist who builds targeting architectures that scale. You understand that the right audience with average creative outperforms the wrong audience with brilliant creative every time. You build layered targeting systems that cover every stage of the buyer journey without overlap or waste.

Build an audience targeting strategy for [BUSINESS/BRAND NAME] selling [PRODUCT/SERVICE] to [IDEAL CUSTOMER PROFILE — demographics, behaviors, job titles, interests]. The business has the following first-party data: [LIST AVAILABLE DATA — email list size, website traffic volume, app users, purchase history, CRM data]. The advertising platforms are [PLATFORMS — Meta, Google, TikTok, LinkedIn, etc.]. The average customer lifetime value is [LTV OR AOV].

1. CUSTOMER PERSONA DEEP DIVE
   - Define 2-3 distinct buyer personas with demographics, psychographics, and digital behavior patterns
   - Identify what each persona searches for, follows, reads, and engages with online
   - Map each persona to a stage in the buying journey (problem-aware, solution-aware, product-aware)
   - List the objections and hesitations each persona has before purchasing
   - Define the signals that indicate high purchase intent for each persona
   - Prioritize personas by revenue potential and ease of acquisition

2. CUSTOM AUDIENCE ARCHITECTURE
   - Design website visitor custom audiences segmented by page visited, time on site, and recency
   - Build purchase-based audiences: repeat buyers, high-AOV buyers, recent buyers, lapsed buyers
   - Create engagement-based audiences: video viewers (25%, 50%, 75%, 95%), ad engagers, page followers
   - Define email list segments to upload: all subscribers, engaged subscribers, leads, customers
   - Build event-based audiences: add-to-cart, initiate-checkout, lead form started but not completed
   - Specify the refresh cadence for each custom audience and the lookback windows

3. LOOKALIKE AND SIMILAR AUDIENCES
   - Recommend the top 5 seed audiences for lookalike creation, ranked by quality
   - Specify the lookalike percentage tiers to test (1%, 2-3%, 5%, 10%) and when to use each
   - Create value-based lookalikes from customer purchase data for highest ROI targeting
   - Explain how to stack and exclude lookalikes to prevent audience overlap
   - Define platform-specific lookalike setup (Meta lookalikes, Google similar audiences, TikTok lookalikes)
   - Recommend the minimum seed audience size for reliable lookalike performance

4. INTEREST AND BEHAVIOR TARGETING
   - Build 3-5 interest-based audience clusters using platform targeting options
   - Use interest stacking (narrowing with AND logic) to create precision audiences
   - Identify behavioral targeting options: purchase behavior, device usage, travel patterns, life events
   - Map interest audiences to each buyer persona for targeted messaging
   - Include competitive targeting: fans of competitor brands, related products, adjacent interests
   - Flag interest categories that are too broad (over 50M) or too narrow (under 100K) to be useful

5. EXCLUSION STRATEGY
   - Define exclusion audiences to prevent wasted spend at every funnel level
   - Exclude recent converters from prospecting campaigns (set the appropriate lookback)
   - Exclude existing customers from acquisition campaigns unless running upsell
   - Remove low-quality traffic sources: accidental clicks, bounced visitors under 5 seconds
   - Prevent audience overlap between ad sets by structuring exclusions hierarchically
   - Create a suppression list for employees, competitors, and unqualified leads

6. PLATFORM-SPECIFIC IMPLEMENTATION
   - Detail the audience setup steps for Meta Ads Manager (custom, lookalike, saved audiences)
   - Detail the audience setup for Google Ads (remarketing lists, customer match, in-market, affinity)
   - Include TikTok and LinkedIn targeting specifics where applicable
   - Recommend Audience Network and placement-specific targeting adjustments
   - Define the audience testing hierarchy — which audiences to launch first and how to expand
   - Set audience performance benchmarks and the rules for retiring underperforming segments

Deliver the strategy as an audience playbook that a media buyer can reference ongoing, with clear naming conventions and setup instructions for every audience across every platform.

Be specific to my situation. No generic filler.
