---
name: ad-creative-brief
description: Creates a creative brief for ad designers with messaging, visuals, and specs. Use when briefing designers on ad creative, aligning team on ad visuals, or commissioning ad design work.
metadata:
  category: ads-paid-media
  author: skillar
  version: "1.0"
---

# Ad Creative Brief Generator

*Because the ad creative determines 80% of campaign performance.*

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A comprehensive creative brief for ad designers that covers messaging hierarchy, visual direction, brand constraints, size specifications, and deliverable requirements so your creative team produces on-strategy ads without endless revision rounds.

## Instructions

You are a creative director. You write briefs that eliminate ambiguity, reduce revision cycles, and give designers the clarity they need to produce high-performing ad creative on the first round.

Write a creative brief for ad assets for [BUSINESS/BRAND NAME] promoting [PRODUCT/SERVICE/OFFER]. The ads will run on [PLATFORMS — e.g., Meta, Google Display, TikTok, LinkedIn, YouTube]. The target audience is [TARGET AUDIENCE DESCRIPTION]. The campaign objective is [OBJECTIVE — awareness, consideration, conversion]. The brand guidelines are [DESCRIBE BRAND STYLE — colors, fonts, logo usage, mood].

1. CAMPAIGN CONTEXT
   - Summarize the campaign goal in one sentence a designer can internalize immediately
   - Describe the target audience in human terms — who they are, what they care about, what stops them
   - State the single most important message the ad must communicate
   - Define the desired emotional response when someone sees the ad
   - Identify the competitive landscape — what other ads is the audience seeing in this space

2. MESSAGING HIERARCHY
   - Define the primary headline message (the one thing people must read)
   - Define the secondary supporting message (proof point or benefit expansion)
   - Define the call-to-action text and button label
   - List 3-5 approved copy variations the designer can choose from
   - Specify any mandatory legal disclaimers, trademark symbols, or compliance text
   - Note any words or phrases that are off-limits for brand or legal reasons

3. VISUAL DIRECTION
   - Describe the visual concept or scene the ad should depict
   - Specify whether to use photography, illustration, 3D renders, or mixed media
   - Provide color palette specifics (hex codes, primary and accent colors)
   - Define typography requirements (font families, minimum sizes for readability)
   - Include 3-5 visual reference links or descriptions of the look and feel
   - Specify logo placement, minimum size, and clear space requirements

4. DELIVERABLE SPECIFICATIONS
   - List every ad size needed with pixel dimensions (e.g., 1080x1080, 1200x628, 1080x1920, 300x250)
   - Specify file formats required (PNG, JPG, GIF, MP4, HTML5)
   - Define maximum file sizes per platform
   - For video assets, specify duration options (6s, 15s, 30s), aspect ratios (1:1, 4:5, 9:16, 16:9)
   - Include safe zone templates for platforms that overlay UI elements on ads
   - State the total number of unique creative concepts and variations expected

5. BRAND GUARDRAILS
   - List the non-negotiable brand elements that must appear in every asset
   - Define what the designer should never do (stretched logos, off-brand colors, stock photo cliches)
   - Provide the brand voice in three adjectives to guide any copy choices the designer makes
   - Include accessibility requirements (contrast ratios, alt text, caption requirements)
   - Reference the brand style guide location or attach key pages

6. TIMELINE AND DELIVERY
   - Set the first draft deadline and final delivery deadline
   - Define the review and approval process (who reviews, how many rounds included)
   - Specify the file naming convention for organized handoff
   - State the delivery method (shared drive, design tool link, asset management platform)
   - Include the contact person for questions and clarification during production

Deliver the brief as a single, clean document that can be shared directly with an internal designer, freelancer, or agency creative team without additional context needed.

Be specific to my situation. No generic filler.
