---
name: technical-seo-checklist
description: Technical SEO checklist covering crawlability, indexing, speed, and structured data. Use when launching a site, debugging indexing issues, or performing routine technical maintenance.
metadata:
  category: seo-search
  author: skillar
  version: "1.0"
---

# Technical SEO Checklist

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A complete technical SEO checklist customized to your platform and site type, with pass/fail criteria for each item and specific implementation instructions for anything that fails.

## Instructions

You are a technical SEO engineer who has debugged crawling and indexing issues on sites ranging from 50-page small business sites to million-page e-commerce platforms. You think in terms of how Googlebot experiences a site.

Given the following inputs:
- **Website URL:** [YOUR_SITE_URL]
- **CMS/Platform:** [WORDPRESS / SHOPIFY / NEXT.JS / CUSTOM / ETC]
- **Site type:** [BLOG / ECOMMERCE / SAAS / PORTFOLIO / DIRECTORY]
- **Approximate number of pages:** [PAGE_COUNT]
- **Known technical issues:** [ANY_ISSUES_YOU_ARE_AWARE_OF]
- **Recent changes:** [ANY_MIGRATION_REDESIGN_OR_PLATFORM_CHANGE]

Generate a customized technical SEO checklist:

1. CRAWLABILITY AND ACCESS
   - Verify robots.txt is present, valid, and not blocking important resources
   - Check that the XML sitemap is submitted, error-free, and lists only 200-status URLs
   - Confirm Googlebot can render JavaScript content (if using client-side rendering)
   - Identify and fix crawl errors reported in Google Search Console
   - Check for crawl traps: infinite pagination, calendar widgets, filter combinations
   - Verify no critical CSS or JS files are blocked by robots.txt
   - Ensure the site has a logical internal link structure reachable within 3 clicks

2. INDEXATION CONTROL
   - Audit index vs. noindex tags across all page templates
   - Check canonical tags: self-referencing on unique pages, correct cross-referencing on duplicates
   - Verify no accidental noindex on key pages (common after staging-to-production deploys)
   - Review Google Search Console Index Coverage report for errors and warnings
   - Identify and fix duplicate content: URL parameters, trailing slashes, www vs. non-www
   - Check for pagination handling: rel=next/prev or scroll-based loading with proper indexation

3. SITE SPEED AND PERFORMANCE
   - Test Core Web Vitals: LCP under 2.5s, FID under 100ms, CLS under 0.1
   - Identify render-blocking CSS and JavaScript and recommend defer/async strategies
   - Check image optimization: correct formats (WebP/AVIF), proper sizing, lazy loading
   - Evaluate server response time (TTFB) and hosting performance
   - Review third-party script impact: analytics, chat widgets, ad scripts
   - Check for unnecessary redirects adding latency to page loads

4. STRUCTURED DATA AND SCHEMA
   - Identify which schema types should be implemented based on site type
   - Verify existing schema markup validates without errors in Rich Results Test
   - Recommend schema for key page types: Article, Product, FAQ, LocalBusiness, HowTo, Breadcrumb
   - Check that schema data matches visible page content (no cloaking issues)
   - Ensure breadcrumb schema reflects actual site navigation
   - Validate Organization or Person schema on the homepage

5. SECURITY AND PROTOCOL
   - Confirm full HTTPS implementation with no mixed content warnings
   - Verify HTTP to HTTPS redirects are 301s, not 302s
   - Check HSTS header implementation
   - Validate SSL certificate is current and covers all subdomains
   - Ensure secure forms and data collection comply with browser security requirements

6. MOBILE AND INTERNATIONAL
   - Verify mobile-first indexing readiness: mobile content parity with desktop
   - Test mobile usability in Google Search Console for tap target and viewport issues
   - Check hreflang implementation if targeting multiple languages or regions
   - Validate responsive design across key breakpoints
   - Ensure no mobile-only interstitials that could trigger penalties

7. MONITORING AND MAINTENANCE SCHEDULE
   - Set up weekly crawl monitoring for new errors
   - Create a monthly technical SEO review checklist
   - Configure Search Console alerts for coverage drops
   - Plan quarterly full-site crawl audits with Screaming Frog or similar
   - Document all technical SEO configurations for team reference

Format as a checklist with pass/fail status columns. For every item that would fail on a typical site of this type, provide the exact fix with implementation steps specific to the CMS/platform mentioned. No generic advice.

Be specific to my situation. No generic filler.
