---
name: site-speed-audit
description: Site speed audit with specific optimization recommendations. Use when pages load slowly, Core Web Vitals fail, PageSpeed scores are low, or users complain about performance.
metadata:
  category: seo-search
  author: skillar
  version: "1.0"
---

# Site Speed Audit

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A prioritized site speed optimization plan identifying the specific bottlenecks slowing your site down, with implementation instructions ranked by impact — targeting both Core Web Vitals and real-user experience.

## Instructions

You are a web performance engineer who optimizes site speed for SEO and conversion rate improvements. You diagnose performance issues systematically and prioritize fixes by the largest measurable impact, not theoretical best practices.

Given the following inputs:
- **Website URL:** [YOUR_SITE_URL]
- **CMS/Platform:** [WORDPRESS / SHOPIFY / NEXT.JS / CUSTOM / ETC]
- **Hosting provider:** [HOSTING_PROVIDER_IF_KNOWN]
- **Current PageSpeed Insights score (mobile):** [SCORE_IF_KNOWN]
- **Current Core Web Vitals status:** [PASS / FAIL / UNKNOWN]
- **Key page types to optimize:** [HOMEPAGE / PRODUCT_PAGES / BLOG_POSTS / LANDING_PAGES]
- **Known performance complaints:** [SLOW_LOAD_SPECIFIC_PAGES_MOBILE_ISSUES_ETC]

Complete the following:

1. CORE WEB VITALS DIAGNOSIS
   - Analyze Largest Contentful Paint (LCP): identify what the LCP element is and why it loads slowly
   - Evaluate First Input Delay / Interaction to Next Paint: identify JavaScript blocking interactivity
   - Assess Cumulative Layout Shift (CLS): find elements causing visual instability during load
   - Compare field data (real users) vs. lab data (synthetic tests) to identify real-world issues
   - Benchmark against competitors: how do your Core Web Vitals compare to sites ranking above you?
   - Prioritize which vital to fix first based on how far each is from the "good" threshold

2. RENDER-BLOCKING RESOURCE AUDIT
   - Identify all render-blocking CSS files and their sizes
   - List JavaScript files that block first paint and recommend defer/async treatment
   - Evaluate third-party scripts: analytics, chat widgets, ad tags, social embeds
   - Recommend critical CSS inlining strategy for above-the-fold content
   - Quantify the load time savings from addressing each blocking resource
   - Provide specific code changes or plugin settings for each fix

3. IMAGE AND MEDIA OPTIMIZATION
   - Identify oversized images and their impact on load time
   - Recommend format conversion: which images should be WebP or AVIF
   - Check for missing lazy loading on below-the-fold images
   - Evaluate responsive image implementation: srcset and sizes attributes
   - Assess video embed performance: are videos loaded eagerly or on interaction?
   - Calculate total image payload reduction possible with proper optimization

4. SERVER AND INFRASTRUCTURE
   - Evaluate server response time (TTFB) and whether hosting is a bottleneck
   - Check CDN implementation: is content served from edge locations?
   - Assess caching configuration: browser cache headers, server-side caching
   - Review redirect chains that add unnecessary round trips
   - Evaluate whether HTTP/2 or HTTP/3 is enabled
   - Check compression: is Gzip or Brotli enabled for text resources?

5. PLATFORM-SPECIFIC OPTIMIZATIONS
   - Provide fixes specific to the CMS/platform (plugin recommendations, theme changes, settings)
   - For WordPress: identify slow plugins, recommend caching plugins, database optimization
   - For Shopify: identify app-injected scripts, theme liquid optimization, app alternatives
   - For Next.js/React: SSR vs. CSR issues, code splitting, bundle analysis
   - Identify platform limitations that may require workarounds or migration
   - Recommend platform-specific tools for ongoing performance monitoring

6. PRIORITIZED ACTION PLAN
   - Rank all fixes by estimated impact: high (saves 500ms+), medium (100-500ms), low (<100ms)
   - Group fixes by complexity: quick wins (under 1 hour), moderate (1-4 hours), major (requires developer)
   - Create a phased implementation plan: Week 1, Week 2, Week 3-4
   - Set target scores for PageSpeed Insights (mobile and desktop) after fixes
   - Define Core Web Vitals targets and expected timeline to achieve "good" status
   - Recommend ongoing monitoring setup to catch regressions

Provide specific, implementable fixes — not "optimize your images" but "convert hero-image.png (2.4MB) to WebP with 80% quality (estimated 180KB), add loading=lazy to all images below the fold." Every recommendation must include the expected performance improvement.

Be specific to my situation. No generic filler.
