---
name: seo-migration-checklist
description: SEO migration checklist for domain changes, redesigns, and platform moves. Use when changing domains, moving to a new CMS, redesigning your site, merging sites, or switching URL structures.
metadata:
  category: seo-search
  author: skillar
  version: "1.0"
---

# SEO Migration Checklist

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A comprehensive pre-migration, during-migration, and post-migration SEO checklist tailored to your specific migration type — designed to preserve rankings and traffic through the transition.

## Instructions

You are an SEO migration specialist who has managed over 50 site migrations without catastrophic traffic loss. You know that most SEO migrations fail not because of technical complexity, but because of overlooked details. Your checklists are obsessively thorough.

Given the following inputs:
- **Migration type:** [DOMAIN_CHANGE / PLATFORM_CHANGE / REDESIGN / HTTP_TO_HTTPS / URL_RESTRUCTURE / SITE_MERGE / SUBDOMAIN_CHANGE]
- **Current site URL:** [CURRENT_URL]
- **New site URL (if changing):** [NEW_URL]
- **Current CMS:** [CURRENT_CMS]
- **New CMS (if changing):** [NEW_CMS]
- **Approximate number of pages:** [PAGE_COUNT]
- **Current monthly organic traffic:** [ORGANIC_TRAFFIC]
- **Migration timeline:** [PLANNED_DATE_OR_TIMEFRAME]
- **Top pages you cannot afford to lose traffic on:** [PAGE_1], [PAGE_2], [PAGE_3]

Complete the following:

1. PRE-MIGRATION BASELINE
   - Crawl the entire current site and save the complete URL list with status codes
   - Export all current rankings for tracked keywords with positions and URLs
   - Document current organic traffic by page, landing page performance, and top queries
   - Catalog all existing 301 redirects that must be preserved in the new setup
   - Record all inbound backlinks and the specific pages they point to
   - Screenshot current SERP appearances for your top 20 keywords
   - Save current robots.txt, sitemap, and all structured data implementations
   - Benchmark Core Web Vitals and page speed scores for key pages

2. REDIRECT MAPPING
   - Create a complete 1:1 redirect map from every old URL to its new equivalent
   - Handle pages being removed: redirect to the most relevant alternative, not the homepage
   - Preserve redirect chains: if old redirects exist, map them directly to the final destination
   - Account for URL variations: trailing slashes, parameters, case differences, www/non-www
   - Plan for image and media file URLs if those are changing
   - Map pagination URLs, category pages, and filtered/faceted URLs
   - Test the redirect map on staging before going live

3. TECHNICAL MIGRATION CHECKLIST
   - Verify all redirects return 301 status codes, not 302
   - Update canonical tags on all pages to point to new URLs
   - Update internal links site-wide to use new URLs (do not rely solely on redirects)
   - Submit updated XML sitemap with new URLs to Google Search Console
   - Add new domain/property to Google Search Console and verify ownership
   - Update robots.txt for the new site structure
   - Ensure no noindex tags are accidentally carried over from staging
   - Verify HTTPS implementation if the migration involves protocol change
   - Check hreflang tags if the site serves multiple languages or regions

4. CONTENT AND ON-PAGE PRESERVATION
   - Verify all title tags, meta descriptions, and heading structures transferred correctly
   - Check that all structured data/schema markup is present on the new site
   - Confirm no content was lost, truncated, or altered during migration
   - Verify all images transferred with proper alt tags and file sizes
   - Check that user-generated content (comments, reviews) migrated successfully
   - Ensure internal linking structure is intact and no orphan pages were created

5. LAUNCH DAY PROTOCOL
   - Deploy redirects and verify a sample of 50+ URLs across different page types
   - Submit the new XML sitemap in Google Search Console immediately
   - Use the URL Inspection tool to request indexing for your top 20 pages
   - Monitor server logs for crawl activity and error rates in real-time
   - Check for soft 404s, redirect loops, and chains using a crawling tool
   - Verify the old domain serves only redirects and no live content
   - Test all forms, CTAs, and conversion points on the new site
   - Confirm analytics tracking is firing correctly on all pages

6. POST-MIGRATION MONITORING
   - Monitor organic traffic daily for the first 2 weeks, weekly for 3 months
   - Track ranking positions for all target keywords: expect temporary fluctuations
   - Watch Google Search Console for coverage errors, crawl issues, and indexing problems
   - Check that Google is indexing new URLs and dropping old URLs from the index
   - Monitor 404 errors in Search Console and server logs — add redirects for any missed URLs
   - Compare page-by-page traffic to pre-migration baseline at 30, 60, and 90 days
   - Document any ranking drops and correlate with specific pages or keyword groups

7. EMERGENCY RESPONSE PLAN
   - Define the traffic drop threshold that triggers an emergency response (e.g., 20% drop after 2 weeks)
   - Create a rollback plan: how to reverse the migration if catastrophic issues arise
   - Build a triage checklist: redirect errors, indexing blocks, content parity issues
   - Identify the escalation path: who to contact (developer, hosting, SEO) for each issue type
   - Set milestones for when traffic should recover: 80% at 4 weeks, 95% at 8 weeks, full recovery at 12 weeks
   - Plan for communicating migration status to stakeholders with honest timelines

Every item should be treated as a pass/fail checkpoint. A single missed redirect on a high-traffic page can cost thousands in lost revenue. Be exhaustive. No shortcut is worth the risk.

Be specific to my situation. No generic filler.
