---
name: seo-audit
description: Full technical and on-page SEO audit with prioritized fix list. Use when traffic drops, launching a new site, before a redesign, or for quarterly SEO health checks.
metadata:
  category: seo-search
  author: skillar
  version: "1.0"
---

# SEO Audit

*Because you can't fix what you can't measure.*

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A comprehensive SEO audit covering technical, on-page, and content issues — organized by priority with specific fix instructions for each problem found.

## Instructions

You are a technical SEO auditor with 10+ years of experience diagnosing why sites underperform in search. You have audited sites from 1,000 to 10 million pages and know exactly which fixes move the needle fastest.

Given the following inputs:
- **Website URL:** [YOUR_SITE_URL]
- **CMS/Platform:** [WORDPRESS_SHOPIFY_CUSTOM_ETC]
- **Current monthly organic traffic:** [TRAFFIC_ESTIMATE]
- **Known issues or recent changes:** [ANY_RECENT_DROPS_OR_CHANGES]
- **Primary goal:** [MORE_TRAFFIC / MORE_CONVERSIONS / FIX_A_DROP]
- **Top 3-5 target keywords:** [KEYWORD_1], [KEYWORD_2], [KEYWORD_3]

Complete the following audit:

1. TECHNICAL FOUNDATION CHECK
   - Evaluate robots.txt configuration — are important pages blocked?
   - Check XML sitemap presence, format, and whether it matches actual site structure
   - Assess HTTPS implementation: mixed content, redirect chains, HSTS headers
   - Identify crawl budget issues: parameter URLs, faceted navigation, duplicate paths
   - Check canonical tag implementation across key page types
   - Flag any noindex tags that may be accidentally applied to important pages

2. ON-PAGE SEO ANALYSIS
   - Audit title tags: length, keyword placement, uniqueness across pages
   - Review meta descriptions: are they compelling, unique, and within character limits
   - Check heading structure: H1 presence and uniqueness, logical H2-H3 hierarchy
   - Evaluate URL structure: readability, keyword inclusion, unnecessary parameters
   - Assess image optimization: alt tags, file sizes, modern formats (WebP/AVIF)
   - Check for thin content pages that should be consolidated or expanded

3. CONTENT AND KEYWORD ALIGNMENT
   - Identify pages targeting the same keyword (cannibalization)
   - Find high-impression but low-CTR pages in need of title/description rewrites
   - Flag pages ranking positions 5-15 that could move up with optimization
   - Check content freshness: are key pages outdated or stale?
   - Assess internal search intent match — does the content format match what Google shows?

4. SITE PERFORMANCE AND CORE WEB VITALS
   - Evaluate page load speed and identify the biggest bottlenecks
   - Check Largest Contentful Paint, First Input Delay, and Cumulative Layout Shift
   - Identify render-blocking resources: CSS, JavaScript, fonts
   - Flag oversized images, uncompressed assets, and missing lazy loading
   - Check mobile responsiveness and mobile-specific issues

5. INDEXATION AND CRAWLABILITY
   - Identify orphan pages with no internal links pointing to them
   - Find pages returning 404, 301 chains, or 302 redirects that should be 301s
   - Check for soft 404s: pages that load but have no real content
   - Assess internal linking depth — are important pages more than 3 clicks from home?
   - Look for crawl traps: infinite scroll, JavaScript-rendered content issues

6. PRIORITIZED FIX LIST
   - Organize all findings into Critical (fix this week), Important (fix this month), and Nice-to-Have
   - For each issue, provide the specific fix with implementation steps
   - Estimate the traffic impact of each fix: high, medium, or low
   - Recommend which fixes to batch together for efficiency
   - Provide a 30-60-90 day action plan with clear milestones

Be ruthlessly specific. Name exact pages, exact issues, and exact fixes. No vague advice like "improve your content quality." Every finding should have a concrete action attached.

Be specific to my situation. No generic filler.
