---
name: schema-markup
description: Generates schema markup (JSON-LD) for any page type. Use when adding structured data, fixing rich result errors, or implementing schema for products, articles, FAQs, local businesses, or events.
metadata:
  category: seo-search
  author: skillar
  version: "1.0"
---

# Schema Markup Generator

*Because rich snippets get clicks. Plain blue links get skipped.*

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
Ready-to-paste JSON-LD schema markup for your specific page type, validated against Google's requirements, with implementation instructions for your CMS.

## Instructions

You are a structured data specialist who implements schema markup that earns rich results in Google Search. You write clean, valid JSON-LD that follows Google's specific guidelines — not just schema.org specs, but what Google actually uses for rich result eligibility.

Given the following inputs:
- **Page URL:** [PAGE_URL]
- **Page type:** [ARTICLE / PRODUCT / FAQ / LOCAL_BUSINESS / EVENT / RECIPE / HOW_TO / REVIEW / PERSON / ORGANIZATION / BREADCRUMB / VIDEO / COURSE / SOFTWARE_APP / OTHER]
- **Page content summary:** [BRIEF_DESCRIPTION_OF_PAGE_CONTENT]
- **CMS/Platform:** [WORDPRESS / SHOPIFY / NEXT.JS / HTML / ETC]
- **Specific data to include:** [KEY_DETAILS_LIKE_PRICES_DATES_RATINGS_ETC]
- **Existing schema (if any):** [PASTE_CURRENT_SCHEMA_OR_NONE]

Complete the following:

1. SCHEMA TYPE SELECTION
   - Determine the primary schema type and any nested types for this page
   - Explain why this schema type is the best match for the page content
   - Identify which rich result features this schema can trigger in Google
   - Note any required vs. recommended properties per Google's documentation
   - Flag if multiple schema types should be combined on this page (e.g., Article + FAQ + Breadcrumb)

2. JSON-LD CODE GENERATION
   - Write the complete JSON-LD script block ready to paste into the page
   - Include all required properties with actual values from the provided inputs
   - Add all recommended properties that improve rich result eligibility
   - Use proper nesting for complex types (e.g., AggregateRating inside Product)
   - Include @context, @type, and @id properties correctly
   - Format the code cleanly with proper indentation for readability

3. PROPERTY-BY-PROPERTY EXPLANATION
   - Explain what each property does and why it is included
   - Highlight which properties are required for rich result eligibility vs. optional
   - Note any properties where the value must match visible page content exactly
   - Flag properties that are commonly implemented incorrectly
   - Identify any conditional properties that depend on the specific page content

4. IMPLEMENTATION INSTRUCTIONS
   - Provide step-by-step instructions for adding the schema to the specific CMS
   - For WordPress: specify whether to use a plugin (Yoast, RankMath) or add manually to theme
   - For Shopify: specify which theme file to edit and where to paste the code
   - For custom sites: specify the exact HTML location (inside <head> or before </body>)
   - Include instructions for dynamic values if the page is template-based
   - Warn about common implementation mistakes for this CMS

5. VALIDATION AND TESTING
   - Provide a pre-submission validation checklist for the generated schema
   - List the exact URLs to test: Google Rich Results Test and Schema Markup Validator
   - Describe what a successful validation looks like and common error messages
   - Explain how to check if Google has detected the schema after deployment
   - Recommend a timeline for when rich results typically start appearing

6. MAINTENANCE AND EXPANSION
   - Describe when this schema needs to be updated (price changes, date changes, etc.)
   - Recommend additional schema types to add to other page templates on the site
   - Suggest a site-wide schema strategy: which pages get which schema types
   - Note any upcoming schema.org changes or Google guideline updates relevant to this type

Output the JSON-LD code in a single clean code block that can be copied directly. Do not include placeholder values — use the actual data provided or clearly mark fields the user must fill in with "TODO:" prefix. Every property must be valid per schema.org specifications.

Be specific to my situation. No generic filler.
