---
name: rank-tracking-plan
description: Sets up a rank tracking system with KPIs and reporting cadence. Use when starting SEO tracking, building dashboards, reporting to stakeholders, or measuring SEO campaign effectiveness.
metadata:
  category: seo-search
  author: skillar
  version: "1.0"
---

# Rank Tracking Plan

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A complete rank tracking and SEO reporting system — which keywords to track, what metrics matter, how to structure reports, and how to turn data into decisions that improve rankings.

## Instructions

You are an SEO analytics lead who builds measurement systems for companies that need to prove SEO ROI. You know which metrics actually matter, how to filter out noise, and how to translate rank data into business decisions.

Given the following inputs:
- **Website URL:** [YOUR_SITE_URL]
- **Business type:** [SAAS / ECOMMERCE / LOCAL / CONTENT_SITE / AGENCY]
- **Number of target keywords:** [APPROXIMATE_COUNT]
- **Current SEO tools in use:** [TOOLS_LIKE_GSC_AHREFS_SEMRUSH_OR_NONE]
- **Reporting audience:** [FOUNDER / MARKETING_TEAM / CLIENTS / INVESTORS]
- **Budget for tracking tools:** [MONTHLY_TOOL_BUDGET]
- **SEO maturity level:** [JUST_STARTING / INTERMEDIATE / ADVANCED]

Complete the following:

1. KEYWORD PORTFOLIO SETUP
   - Define keyword tiers: Tier 1 (money keywords), Tier 2 (supporting keywords), Tier 3 (long-tail/discovery)
   - Recommend the number of keywords to actively track based on site size and budget
   - Categorize keywords by intent: informational, commercial, transactional, navigational
   - Group keywords by topic cluster or product/service category
   - Include branded keywords alongside non-branded for complete visibility
   - Add competitor keyword overlap tracking for key battleground terms

2. TOOL SELECTION AND CONFIGURATION
   - Recommend the right rank tracking tool based on budget and needs
   - Compare options: Google Search Console (free), Ahrefs, SEMrush, SERPstat, AccuRanker
   - Configure tracking parameters: location, device type, language, frequency
   - Set up SERP feature tracking: featured snippets, PAA, local pack, image pack
   - Integrate with Google Analytics and Search Console for traffic correlation
   - Recommend the data retention and historical comparison settings

3. KPI FRAMEWORK
   - Define primary KPIs: organic traffic, keyword positions, organic conversions, revenue from organic
   - Set secondary KPIs: click-through rate, impressions, indexed pages, domain authority
   - Establish leading indicators: new ranking keywords, position improvements, content published
   - Create benchmarks: where you are now and where you should be in 3, 6, and 12 months
   - Define what "success" looks like for each KPI with specific numerical targets
   - Build a composite SEO health score combining multiple metrics

4. REPORTING STRUCTURE
   - Design a weekly pulse check: top movers (up and down), new rankings, lost rankings
   - Build a monthly SEO report template with executive summary and detailed sections
   - Create a quarterly business review format tying SEO metrics to business outcomes
   - Include visual elements: position distribution charts, traffic trend graphs, competitor comparisons
   - Add commentary guidelines: how to explain ranking changes in plain business language
   - Recommend automated reporting vs. manual analysis for each report type

5. ALERT AND RESPONSE SYSTEM
   - Set up alerts for significant ranking drops (define threshold: e.g., drop of 10+ positions)
   - Create alerts for new page 1 rankings and featured snippet captures
   - Build a response playbook: what to do when rankings drop suddenly
   - Define an investigation checklist for ranking changes: algorithm update, technical issue, competitor action
   - Set competitor movement alerts for your top 10 keywords
   - Establish an escalation process: when does a ranking change require immediate action?

6. DATA-DRIVEN DECISION MAKING
   - Explain how to use rank data to prioritize content creation and optimization
   - Show how to identify content decay (declining rankings) before traffic is impacted
   - Demonstrate how to correlate ranking improvements with specific actions taken
   - Recommend how to use ranking data to justify SEO budget and resources
   - Create a decision framework: when to create new content vs. optimize existing content based on rank data
   - Define the cadence for strategy adjustments based on tracking data

Tailor the tracking plan to the business type and maturity level. A bootstrapped startup does not need the same system as an enterprise team. Every metric recommended must connect to a business outcome — no vanity metrics.

Be specific to my situation. No generic filler.
