---
name: local-seo-plan
description: Local SEO optimization plan for businesses targeting geographic areas. Use when setting up Google Business Profile, improving local rankings, or expanding to new locations.
metadata:
  category: seo-search
  author: skillar
  version: "1.0"
---

# Local SEO Plan

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A complete local SEO action plan covering Google Business Profile optimization, local citations, review strategy, and geo-targeted content — designed to get you into the local pack and map results.

## Instructions

You are a local SEO specialist who has helped hundreds of brick-and-mortar businesses, service-area businesses, and multi-location brands dominate local search results. You know exactly what moves the needle for local pack rankings.

Given the following inputs:
- **Business name:** [BUSINESS_NAME]
- **Business type:** [RESTAURANT / PLUMBER / DENTIST / ETC]
- **Location(s):** [CITY_STATE_AND_SERVICE_AREA]
- **Website URL:** [YOUR_SITE_URL]
- **Google Business Profile status:** [CLAIMED / NOT_CLAIMED / OPTIMIZED]
- **Number of current Google reviews:** [REVIEW_COUNT]
- **Top 3 services/products:** [SERVICE_1], [SERVICE_2], [SERVICE_3]
- **Main local competitors:** [COMPETITOR_1], [COMPETITOR_2]

Complete the following:

1. GOOGLE BUSINESS PROFILE OPTIMIZATION
   - Audit the current GBP listing for completeness and accuracy
   - Optimize business name, category (primary + secondary), and description with local keywords
   - Recommend the exact categories to select based on what top-ranking competitors use
   - Set up products/services sections with descriptions and pricing where applicable
   - Plan a GBP posting schedule: frequency, content types, and CTAs that drive engagement
   - Optimize photos: storefront, interior, team, products — specify quantity and naming conventions

2. LOCAL KEYWORD STRATEGY
   - Identify the top 15-20 local keywords combining services with geographic modifiers
   - Map "near me" and implicit local intent keywords for each service
   - Find neighborhood, district, and suburb-level keywords beyond just the city name
   - Identify local long-tail keywords with lower competition and high conversion intent
   - Create a keyword-to-page mapping: which keyword targets which page on the site

3. ON-SITE LOCAL OPTIMIZATION
   - Optimize the homepage for the primary city and service combination
   - Create or improve location pages with unique content (not just swapped city names)
   - Add proper NAP (Name, Address, Phone) consistency across every page
   - Implement LocalBusiness schema markup with correct properties
   - Optimize title tags and meta descriptions with local keywords and trust signals
   - Add an embedded Google Map and driving directions to contact/location pages

4. CITATION AND DIRECTORY STRATEGY
   - List the top 20 citation sources for this specific business category
   - Identify NAP inconsistencies across existing citations and how to fix them
   - Prioritize directories by authority: general (Yelp, BBB) vs. industry-specific
   - Recommend data aggregator submissions for broad citation distribution
   - Create a citation audit checklist to ensure consistency across all listings

5. REVIEW GENERATION AND MANAGEMENT
   - Design a review generation system: when and how to ask customers for reviews
   - Create 3 review request templates: in-person, email, and SMS
   - Build a review response strategy: templates for positive, neutral, and negative reviews
   - Set a monthly review acquisition target based on competitor benchmarks
   - Identify review platforms beyond Google that matter for this industry
   - Plan how to showcase reviews on the website for trust and conversion

6. LOCAL CONTENT AND LINK BUILDING
   - Propose 5 locally-focused content pieces that attract local links and traffic
   - Identify local link opportunities: chambers of commerce, local news, community events
   - Suggest local sponsorships or partnerships that generate citations and links
   - Plan seasonal or event-based content tied to the local area
   - Recommend community involvement strategies that double as link building

7. TRACKING AND REPORTING
   - Set up local rank tracking for target keywords with geographic specificity
   - Define KPIs: local pack appearances, GBP views, direction requests, phone calls
   - Create a monthly reporting template for local SEO progress
   - Set benchmarks for review velocity, citation count, and local visibility score

Be specific to the business type and location. Generic advice like "get more reviews" is not enough — specify exactly how many, from which platforms, and with what messaging. Every recommendation should be immediately actionable.

Be specific to my situation. No generic filler.
