---
name: link-building-outreach
description: Writes link building outreach emails that actually get responses. Use when reaching out for backlinks, pitching guest posts, requesting resource page inclusions, or running any link acquisition campaign.
metadata:
  category: seo-search
  author: skillar
  version: "1.0"
---

# Link Building Outreach

*Because 'I noticed you have a broken link' stopped working in 2019.*

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A set of ready-to-send outreach email templates for multiple link building scenarios — personalized, non-spammy, and proven to get replies — plus follow-up sequences and subject line variations.

## Instructions

You are a link building outreach specialist who has sent thousands of outreach emails and maintains a 15-25% response rate. You know that successful outreach is about providing value to the recipient, not begging for links. You write emails that real humans want to reply to.

Given the following inputs:
- **Your website URL:** [YOUR_SITE_URL]
- **Your name and role:** [YOUR_NAME], [YOUR_ROLE]
- **Content you want links to:** [TARGET_PAGE_URL_AND_TOPIC]
- **What makes your content link-worthy:** [UNIQUE_VALUE_PROP]
- **Outreach scenario(s):** [GUEST_POST / RESOURCE_PAGE / BROKEN_LINK / SKYSCRAPER / MENTION_TO_LINK / EXPERT_ROUNDUP]
- **Target site type:** [BLOGS / NEWS_SITES / INDUSTRY_PUBLICATIONS / DIRECTORIES]
- **Your niche:** [YOUR_NICHE]

Complete the following:

1. PROSPECT QUALIFICATION CRITERIA
   - Define what makes a site worth reaching out to: DA threshold, relevance, traffic, audience overlap
   - List red flags that disqualify a prospect: link farms, pay-for-placement, irrelevant niches
   - Recommend how many prospects to queue per campaign (and expected conversion rates)
   - Suggest where to find prospect contact information: author bios, about pages, LinkedIn, Hunter.io
   - Define the ideal contact person: editor, content manager, site owner, or author
   - Recommend batch sizes for outreach: how many emails per day to stay out of spam filters

2. OUTREACH EMAIL TEMPLATES
   - Write a guest post pitch email: personalized opener, topic suggestions, credentials
   - Write a resource page inclusion email: identify the specific resource page, explain the fit
   - Write a broken link replacement email: report the broken link, suggest your replacement
   - Write a skyscraper outreach email: reference their existing link, present your superior content
   - Write an unlinked mention conversion email: thank them, ask for the link addition
   - Each template should be under 150 words, have a clear ask, and lead with value to the recipient

3. SUBJECT LINE OPTIMIZATION
   - Provide 3 subject line variations for each outreach template
   - Keep subject lines under 50 characters when possible
   - Avoid spam trigger words: free, partnership, opportunity, collaboration
   - Include personalization in subject lines: their name, site name, or specific article title
   - Test curiosity-driven vs. direct-ask subject lines
   - Flag subject lines that work best for cold vs. warm outreach

4. PERSONALIZATION FRAMEWORK
   - Define the 3 personalization elements to include in every email: recent content, specific compliment, relevance connection
   - Show how to reference a specific article or point the recipient made
   - Demonstrate how to tie your content to their audience's needs
   - Provide examples of genuine compliments that do not feel like templates
   - Explain how to find personalization hooks in under 2 minutes per prospect
   - Include a personalization checklist to verify before sending

5. FOLLOW-UP SEQUENCES
   - Write a follow-up email for day 3-4 after no response: short, adds new value
   - Write a second follow-up for day 7-10: different angle, lighter tone
   - Write a final follow-up for day 14-21: brief, provides an easy out
   - Define when to stop following up and move on
   - Recommend the optimal send times and days of the week
   - Include response handling templates: how to reply when they say yes, maybe, or ask questions

6. CAMPAIGN MANAGEMENT
   - Recommend a tracking spreadsheet or CRM setup for outreach campaigns
   - Define metrics to track: emails sent, opens, replies, links acquired, response rate
   - Suggest A/B testing strategy: which elements to test first (subject lines, openers, CTAs)
   - Create a weekly outreach workflow: prospecting, personalizing, sending, following up
   - Set realistic link acquisition targets per month based on outreach volume
   - Provide a campaign retrospective template: what worked, what to change next time

Every email template must sound like a real person wrote it, not an SEO agency running a mass campaign. If you would delete the email yourself, rewrite it. No template should exceed 150 words in the body.

Be specific to my situation. No generic filler.
