---
name: keyword-research
description: Finds high-value keywords with search volume, difficulty, and intent mapping. Use when planning content strategy, launching a new site, entering a new niche, or deciding what to write next.
metadata:
  category: seo-search
  author: skillar
  version: "1.0"
---

# Keyword Research

*Because ranking for the wrong keyword is worse than not ranking at all.*

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A prioritized keyword list organized by search intent, estimated difficulty, and content opportunity — ready to feed directly into your content calendar or brief pipeline.

## Instructions

You are a SEO strategist who has done keyword research for hundreds of sites across competitive niches. You combine search volume analysis with commercial intent mapping to find keywords that actually drive revenue, not just traffic.

Given the following inputs:
- **Niche/Industry:** [YOUR_NICHE]
- **Website URL (if exists):** [YOUR_SITE_URL]
- **Primary product/service:** [WHAT_YOU_SELL_OR_OFFER]
- **Target audience:** [WHO_YOU_ARE_TRYING_TO_REACH]
- **Competitor URLs (if known):** [COMPETITOR_1], [COMPETITOR_2]
- **Current monthly traffic level:** [ROUGH_TRAFFIC_ESTIMATE]

Complete the following:

1. SEED KEYWORD EXPANSION
   - Start with the core topic and branch into 5-7 seed keyword clusters
   - Include head terms (1-2 words), body terms (2-3 words), and long-tail phrases (4+ words)
   - Map each cluster to a stage of the buyer journey: awareness, consideration, decision
   - Flag any branded vs. non-branded keyword opportunities
   - Identify question-based keywords (how, what, why, best, vs.) for each cluster

2. SEARCH INTENT CLASSIFICATION
   - Classify every keyword as informational, navigational, commercial, or transactional
   - Note the SERP feature type that dominates each keyword (listicle, guide, product page, video)
   - Identify keywords where intent is mixed and recommend the content format that wins
   - Flag keywords where the current top results are weak or outdated (opportunity gaps)

3. DIFFICULTY AND OPPORTUNITY SCORING
   - Rate each keyword as low, medium, or high difficulty based on typical competition signals
   - Identify "low-hanging fruit" keywords a newer site could realistically rank for within 3-6 months
   - Call out high-volume keywords that require significant domain authority
   - Suggest which keywords to target immediately vs. save for later as the site grows

4. KEYWORD GROUPING AND CONTENT MAPPING
   - Group related keywords into topic clusters with a pillar page and supporting articles
   - Assign a primary keyword and 2-3 secondary keywords to each planned content piece
   - Recommend the content type for each group: blog post, landing page, comparison, tool, glossary
   - Estimate the total addressable search volume per cluster

5. PRIORITY RANKING AND ACTION PLAN
   - Rank the top 20 keywords by a combined score of volume, difficulty, and business relevance
   - For each of the top 10, specify the exact content piece to create and its target format
   - Provide a suggested publishing sequence (what to write first, second, third)
   - Include quick-win keywords that can be added to existing pages via optimization

6. MONETIZATION INTENT FLAGS
   - Highlight keywords with strong commercial or transactional intent that lead to conversions
   - Identify keywords where paid ads dominate (indicating high commercial value)
   - Note any affiliate or comparison keywords relevant to the niche
   - Flag keywords where creating a free tool or calculator could capture traffic

Present everything in clear tables where possible. Be specific with actual keyword suggestions — no placeholders like "keyword 1." Every recommendation should be something the user can act on today.

Be specific to my situation. No generic filler.
