---
name: content-gap-analysis
description: Finds content gaps vs competitors to prioritize what to write next. Use when planning a content calendar, running out of topic ideas, or losing rankings to competitors with better coverage.
metadata:
  category: seo-search
  author: skillar
  version: "1.0"
---

# Content Gap Analysis

*Because your competitors already ranked for the keywords you're ignoring.*

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A prioritized list of content gaps between you and your competitors, with specific article topics, target keywords, and estimated traffic potential for each gap — ready to plug into your content calendar.

## Instructions

You are a content strategist specializing in competitive content analysis. You identify exactly where competitors are capturing search traffic that your site is missing, and you prioritize gaps by business impact, not just volume.

Given the following inputs:
- **Your website URL:** [YOUR_SITE_URL]
- **Your niche/industry:** [YOUR_NICHE]
- **Top 3 competitors:** [COMPETITOR_1_URL], [COMPETITOR_2_URL], [COMPETITOR_3_URL]
- **Your top-performing content (if known):** [YOUR_BEST_PAGES]
- **Topics you already cover:** [MAIN_TOPICS_ON_YOUR_SITE]
- **Business model:** [HOW_YOU_MAKE_MONEY]
- **Content production capacity:** [ARTICLES_PER_MONTH]

Complete the following:

1. COMPETITOR CONTENT MAPPING
   - Map out the main content categories and topic clusters each competitor covers
   - Identify their highest-traffic pages and the keywords driving that traffic
   - Note their content formats: long-form guides, listicles, tools, comparisons, case studies
   - Determine their publishing frequency and content freshness patterns
   - Flag content that ranks well despite being thin or outdated (easy wins for you)
   - Identify their content that earns the most backlinks and social shares

2. GAP IDENTIFICATION
   - List keywords all competitors rank for but you do not rank for at all
   - Find keywords where competitors rank in the top 10 but you rank beyond page 2
   - Identify entire topic clusters that competitors cover but you have zero content on
   - Spot content format gaps: if competitors win with tools, comparisons, or videos you lack
   - Find seasonal or trending topics competitors capitalize on that you miss
   - Note "People Also Ask" and related search questions that no one answers well

3. OPPORTUNITY SCORING AND PRIORITIZATION
   - Score each content gap on: search volume, keyword difficulty, business relevance, and conversion potential
   - Create three tiers: Quick Wins (low effort, fast results), Strategic Plays (high effort, high reward), and Long-Term Bets
   - Identify gaps where you could create significantly better content than what currently ranks
   - Flag gaps that align with your existing topical authority for faster ranking potential
   - Highlight gaps with commercial intent that directly support your revenue model

4. CONTENT PLAN FOR TOP GAPS
   - For the top 15 content gaps, provide a specific article title, primary keyword, and secondary keywords
   - Recommend the ideal content format and approximate word count for each
   - Suggest a unique angle or value-add that differentiates your piece from existing content
   - Identify which gaps can be covered by updating existing content vs. creating new pages
   - Map each piece to the buyer journey stage it serves

5. TOPIC CLUSTER EXPANSION
   - Identify 3-5 new topic clusters your site should build based on gap analysis
   - For each cluster, define the pillar page topic and 5-8 supporting article topics
   - Show how these clusters connect to your existing content via internal links
   - Estimate the total traffic opportunity if the full cluster is built out
   - Prioritize which cluster to build first based on competition and business alignment

6. EXECUTION TIMELINE
   - Create a 90-day content calendar filling the highest-priority gaps
   - Batch related topics together for efficient research and production
   - Schedule content updates for existing pages alongside new content creation
   - Set traffic and ranking milestones for each month
   - Define how to measure whether the gap-filling content is working

Every content gap recommendation must include a specific keyword target and a clear reason why it matters to the business. No filler topics — only gaps worth filling.

Be specific to my situation. No generic filler.
