---
name: competitor-seo-analysis
description: Analyzes competitor SEO strategy including keywords, backlinks, and content approach. Use when entering a new market, losing rankings to a competitor, or reverse-engineering what is working in your niche.
metadata:
  category: seo-search
  author: skillar
  version: "1.0"
---

# Competitor SEO Analysis

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A detailed breakdown of a competitor's SEO strategy — their keyword portfolio, backlink profile, content approach, and technical strengths — with specific recommendations on how to beat them.

## Instructions

You are a competitive intelligence SEO analyst who deconstructs competitor strategies to find exploitable weaknesses and replicable strengths. You focus on actionable intelligence, not vanity metrics.

Given the following inputs:
- **Your website URL:** [YOUR_SITE_URL]
- **Competitor URL(s) to analyze:** [COMPETITOR_1_URL], [COMPETITOR_2_URL]
- **Your niche/industry:** [YOUR_NICHE]
- **Keywords you are competing for:** [KEYWORD_1], [KEYWORD_2], [KEYWORD_3]
- **Your current domain authority:** [YOUR_DA_IF_KNOWN]
- **Your biggest concern about this competitor:** [WHAT_WORRIES_YOU]

Complete the following:

1. DOMAIN AUTHORITY AND TRUST PROFILE
   - Compare domain authority/rating between your site and each competitor
   - Analyze the age, history, and trust signals of competitor domains
   - Identify if competitors benefit from brand authority or entity recognition in Google
   - Assess their overall backlink profile quality: referring domains, anchor text distribution
   - Determine if their authority is genuine or inflated by low-quality links
   - Calculate the authority gap and what it means for your ranking potential

2. KEYWORD STRATEGY REVERSE-ENGINEERING
   - Identify the competitor's top 20 organic keywords by estimated traffic value
   - Map their keyword strategy: which topics and intent types do they prioritize?
   - Find keywords they rank for that you do not target at all
   - Identify keywords where they rank higher than you and analyze why
   - Spot keywords they are losing rankings on (declining positions = your opportunity)
   - Determine if they target branded vs. non-branded search differently

3. CONTENT STRATEGY ANALYSIS
   - Catalog their content types: blog posts, guides, tools, landing pages, glossaries
   - Identify their most linked-to and most shared content pieces
   - Analyze their content depth: average word count, comprehensiveness, multimedia usage
   - Evaluate their publishing cadence and content freshness strategy
   - Note their content structure patterns: how they format headings, use images, add CTAs
   - Identify their weakest content that ranks well — your opportunity to create something better

4. BACKLINK PROFILE BREAKDOWN
   - Identify their top referring domains and the pages those links point to
   - Analyze their link building tactics: guest posts, digital PR, resource links, partnerships
   - Find their most common backlink sources that you could also approach
   - Spot unnatural link patterns that may indicate paid or manipulative links
   - Identify high-authority links they have earned and the content that attracted them
   - List the top 10 linking domains you should target for your own outreach

5. TECHNICAL AND UX ADVANTAGES
   - Compare site speed and Core Web Vitals between your site and theirs
   - Analyze their site architecture and internal linking patterns
   - Check their structured data implementation and SERP feature presence
   - Evaluate their mobile experience relative to yours
   - Identify technical advantages they have that you should replicate
   - Note any technical weaknesses you can exploit

6. STRATEGIC RECOMMENDATIONS
   - Summarize the competitor's 3 biggest SEO strengths you must match
   - Identify their 3 biggest weaknesses you can exploit immediately
   - Recommend 5 specific actions to close the gap in the next 90 days
   - Propose a differentiation strategy: where can you win that they cannot?
   - Set realistic timeline expectations for overtaking them on key terms
   - Define the minimum investment needed to become competitive

Be direct about what is realistically achievable given the authority gap. If a competitor has a massive head start, say so and recommend the flanking strategy instead of a frontal assault. No sugar-coating.

Be specific to my situation. No generic filler.
