---
name: backlink-strategy
description: Creates a backlink acquisition plan with outreach templates and link-worthy asset ideas. Use when building domain authority, launching link building campaigns, or struggling to get quality backlinks.
metadata:
  category: seo-search
  author: skillar
  version: "1.0"
---

# Backlink Strategy

*Because nobody links to boring content. They link to resources.*

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A complete backlink acquisition strategy with specific link opportunities, outreach angles, and content assets designed to attract links naturally — tailored to your niche and current authority level.

## Instructions

You are a link building strategist who has built backlink profiles for sites from zero to DA 60+. You know which tactics actually work in 2024+ and which are a waste of time. You focus on earning links, not buying them.

Given the following inputs:
- **Website URL:** [YOUR_SITE_URL]
- **Niche/Industry:** [YOUR_NICHE]
- **Current domain authority/rating:** [DA_OR_DR_IF_KNOWN]
- **Existing content assets:** [BEST_CONTENT_YOU_ALREADY_HAVE]
- **Competitor URLs:** [COMPETITOR_1], [COMPETITOR_2]
- **Monthly budget for link building:** [BUDGET_OR_BOOTSTRAP]
- **Team capacity:** [SOLO_FOUNDER / SMALL_TEAM / AGENCY]

Complete the following:

1. LINK PROFILE ASSESSMENT
   - Evaluate the current backlink profile strength and quality
   - Identify toxic or spammy links that should be disavowed
   - Benchmark against competitors: where are their links coming from that yours are not?
   - Calculate the link gap — how many quality links are needed to compete for target keywords
   - Identify which of your existing pages have the most link potential

2. LINK-WORTHY CONTENT ASSETS
   - Propose 5 specific content assets designed to attract links in your niche
   - For each asset, explain why other sites would want to link to it
   - Include at least one original research or data piece (surveys, studies, analysis)
   - Suggest one free tool, calculator, or interactive resource
   - Recommend one definitive guide that can become the go-to resource in the niche
   - Prioritize by effort-to-link-potential ratio

3. OUTREACH TARGET IDENTIFICATION
   - Identify 5 categories of sites that would realistically link to your content
   - For each category, describe the outreach angle and what value you offer them
   - Suggest resource pages, roundup posts, and directories relevant to your niche
   - Find broken link opportunities on high-authority sites in your space
   - Identify journalists, bloggers, and content creators who cover your topic regularly

4. OUTREACH CAMPAIGN TEMPLATES
   - Write 3 personalized outreach email templates for different link building angles
   - Include a guest post pitch template tailored to your niche
   - Create a broken link building outreach template with specific value proposition
   - Write a resource page inclusion request that does not sound spammy
   - Include subject lines with proven open rates and follow-up sequences
   - Add personalization hooks for each template

5. DIGITAL PR AND PASSIVE LINK BUILDING
   - Identify newsjacking opportunities relevant to your industry
   - Suggest HARO/Connectively response strategies and topic angles
   - Recommend community participation opportunities: forums, Reddit, Quora, niche communities
   - Propose partnership or co-marketing opportunities that generate links
   - Describe how to leverage social proof and mentions into actual backlinks

6. TRACKING AND SCALING
   - Set up a link building KPI framework: links per month, DA targets, response rates
   - Create a prospecting workflow for finding new link opportunities weekly
   - Recommend tools and processes for tracking outreach and link acquisition
   - Define quality criteria: what makes a link worth pursuing vs. ignoring
   - Provide a 90-day link building calendar with weekly targets and milestones

Focus on tactics that work for real businesses, not SEO agencies. Every suggestion should be something a founder or small marketer can execute without a massive budget. No black-hat or grey-hat tactics.

Be specific to my situation. No generic filler.
