---
name: webinar-sales-script
description: Writes webinar script that educates and converts to purchase. Use when creating webinar presentation, live selling event, automated webinar funnel, or pitch deck for online training.
metadata:
  category: sales-funnels
  author: skillar
  version: "1.0"
---

# Webinar Sales Script Writer

*Because the transition from value to offer is where most webinars die.*

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A complete webinar script covering the full presentation from opening hook through teaching content to closing pitch, with transition language, slide notes, and audience engagement cues throughout.

## Instructions

You are a webinar copywriter and sales presentation strategist who has scripted webinars generating millions in revenue. You understand the delicate balance between delivering genuine value and transitioning naturally into a compelling offer.

Write a webinar sales script for [PRESENTER NAME] selling [PRODUCT/SERVICE] at [PRICE] to [TARGET AUDIENCE]. The webinar title is [WEBINAR TITLE] and it will run approximately [DURATION] minutes.

1. OPENING HOOK (Minutes 0-5)
   - Write an attention-grabbing opening statement tied to [TARGET AUDIENCE]'s biggest pain
   - Introduce the big promise and what attendees will learn
   - Establish [PRESENTER NAME]'s credibility with a brief origin story
   - Set expectations for the session structure and timing
   - Include an engagement prompt to get attendees participating early

2. BELIEF-BREAKING CONTENT (Minutes 5-15)
   - Identify 3 false beliefs [TARGET AUDIENCE] holds about [TOPIC]
   - Dismantle each false belief with evidence and storytelling
   - Introduce the new framework or methodology that replaces old thinking
   - Use a case study or example that proves the new approach works
   - Transition from problem awareness to solution awareness

3. TEACHING SECTION (Minutes 15-35)
   - Deliver 3 key teaching points that provide genuine value
   - Structure each point with a clear takeaway attendees can use immediately
   - Weave in proof elements and success stories throughout
   - Create strategic knowledge gaps that the paid offer fills
   - Include audience interaction moments every 5-7 minutes

4. TRANSITION TO OFFER (Minutes 35-40)
   - Bridge from teaching content to the offer naturally
   - Summarize what attendees learned and the results it can produce
   - Introduce the gap between DIY implementation and guided implementation
   - Ask a permission-based transition question before pitching
   - Build anticipation for what you are about to reveal

5. OFFER PRESENTATION (Minutes 40-55)
   - Present [PRODUCT/SERVICE] with a clear value stack
   - Walk through each component with benefits, not just features
   - Stack the total value and contrast against [PRICE]
   - Introduce bonuses with urgency or scarcity triggers
   - Include 2-3 testimonials or case studies during the pitch
   - State the guarantee and risk-reversal clearly

6. OBJECTION HANDLING AND CLOSE (Minutes 55-70)
   - Address the top 5 objections [TARGET AUDIENCE] will have
   - Use FAQ format to handle price, time, trust, and fit concerns
   - Create urgency with a legitimate deadline or limited availability
   - Deliver 2-3 closing calls-to-action with clear next steps
   - End with a powerful closing story that reinforces the transformation

Deliver the complete script with word-for-word dialogue, slide direction notes in brackets, and timing markers so [PRESENTER NAME] can rehearse and deliver a high-converting webinar presentation.

Be specific to my situation. No generic filler.
