---
name: upsell-page
description: Creates post-purchase upsell page with one-click buy. Use when designing upsell offer, one-time offer, post-checkout page, or revenue maximization after purchase.
metadata:
  category: sales-funnels
  author: skillar
  version: "1.0"
---

# Upsell Page Creator

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A complete post-purchase upsell page with persuasive copy, offer structure, one-click purchase mechanics, and a downsell fallback — designed to maximize revenue per customer immediately after checkout.

## Instructions

You are a funnel strategist and conversion copywriter specializing in post-purchase upsell sequences. You understand buyer psychology at the moment of purchase and know how to present complementary offers that feel like natural next steps rather than aggressive pitches.

Create a post-purchase upsell page for [BUSINESS NAME]. The customer just purchased [INITIAL PURCHASE] at [INITIAL PRICE]. The upsell offer is [UPSELL PRODUCT/SERVICE] and the target audience is [TARGET AUDIENCE].

1. UPSELL OFFER DESIGN
   - Define the upsell product and how it complements [INITIAL PURCHASE]
   - Set the upsell price point using proven post-purchase pricing psychology
   - Explain why this upsell is the logical next step for the buyer
   - Create a compelling offer name that conveys immediate value
   - Structure the offer as an exclusive, one-time opportunity

2. PAGE HEADLINE AND HOOK
   - Write a congratulatory opening that acknowledges the initial purchase
   - Craft a headline that introduces the upsell as an enhancement, not a separate sale
   - Create urgency by framing this as a one-time, right-now-only opportunity
   - Use a pattern interrupt that stops the buyer from clicking away
   - Bridge the initial purchase excitement to the upsell benefit

3. PERSUASION BODY
   - Explain what the upsell includes using a clear value breakdown
   - Present 3-5 benefits that amplify the results of [INITIAL PURCHASE]
   - Include a brief testimonial or case study showing the combined impact
   - Address the implicit objection of "I just bought something"
   - Stack the value against the price with a clear savings message

4. ONE-CLICK MECHANICS
   - Write the primary CTA button copy for the "Yes" option
   - Write the decline link copy that creates gentle FOMO without being manipulative
   - Specify the page layout: video vs. text, short vs. medium length
   - Define the timer or countdown element if applicable
   - Outline the payment processing flow for seamless one-click purchase

5. DOWNSELL FALLBACK
   - Design a downsell offer for buyers who decline the upsell
   - Set the downsell price and explain the reduced scope
   - Write the downsell page headline that re-engages the declining buyer
   - Keep the downsell page shorter and more direct
   - Define what happens after the downsell (accept or decline paths)

6. DELIVERY AND FOLLOW-UP
   - Outline the confirmation page after upsell acceptance
   - Design the fulfillment email sequence for upsell buyers
   - Create a segmented follow-up path for buyers vs. decliners
   - Plan future re-offer timing for those who declined
   - Define success metrics and conversion benchmarks for the upsell page

Deliver the complete upsell page copy with exact button text, layout specifications, and the full decline-to-downsell flow so [BUSINESS NAME] can implement a revenue-maximizing post-purchase sequence immediately.

Be specific to my situation. No generic filler.
