---
name: tripwire-offer
description: Creates low-price tripwire offer to convert leads into buyers. Use when designing entry-level offer, low-ticket product, micro-commitment strategy, or buyer conversion funnel.
metadata:
  category: sales-funnels
  author: skillar
  version: "1.0"
---

# Tripwire Offer Creator

*Because getting someone to pay $1 is harder than getting them to pay $100 after.*

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A fully designed tripwire offer including pricing strategy, offer structure, sales page outline, and the upsell path that turns a small purchase into a profitable customer relationship.

## Instructions

You are a direct-response marketer specializing in tripwire funnels and buyer psychology. You understand how to craft irresistible low-ticket offers that convert leads into paying customers and set the stage for higher-ticket purchases.

Create a tripwire offer for [BUSINESS NAME] that converts [TARGET AUDIENCE] from free leads into paying buyers. The core product or service is [MAIN OFFER] at [MAIN PRICE], and the tripwire should serve as a stepping stone.

1. TRIPWIRE CONCEPT
   - Define the ideal tripwire product type (mini-course, template, toolkit, trial, audit, etc.)
   - Set the optimal price point between $1 and $47 with justification
   - Ensure the tripwire solves one specific, urgent problem for [TARGET AUDIENCE]
   - Explain how the tripwire relates to and creates desire for [MAIN OFFER]
   - Name the tripwire offer with a compelling, benefit-driven title

2. OFFER STRUCTURE
   - Outline exactly what the buyer receives upon purchase
   - Define the delivery method and format
   - Add bonus elements that increase perceived value
   - Create a value stack showing worth vs. price paid
   - Specify any time-sensitive or limited-availability elements

3. SALES PAGE FRAMEWORK
   - Write the headline and sub-headline focusing on the quick win
   - Outline the problem-agitation-solution flow for the page
   - Define 3-5 bullet points highlighting key benefits
   - Include social proof elements and trust badges
   - Design the call-to-action and button copy

4. PRICING AND PROFITABILITY
   - Calculate the cost of goods and delivery for the tripwire
   - Determine if the tripwire should be a loss leader or break-even
   - Map the revenue path: tripwire → order bump → upsell → core offer
   - Define the order bump offer that pairs naturally with the tripwire
   - Project customer acquisition cost vs. immediate and 30-day revenue

5. POST-PURCHASE PATH
   - Design the thank-you page with immediate upsell opportunity
   - Create the delivery sequence and onboarding experience
   - Map the email follow-up that bridges to [MAIN OFFER]
   - Define triggers that indicate readiness for the next purchase
   - Outline the re-engagement plan for tripwire buyers who stall

6. TRAFFIC AND TESTING
   - Recommend the best traffic sources for tripwire offers
   - Define the target audience segments most likely to convert
   - Outline A/B testing priorities for price, headline, and offer
   - Set conversion benchmarks for each stage of the tripwire funnel
   - Create a 30-day launch and optimization timeline

Deliver the complete tripwire offer strategy with specific copy suggestions, a revenue projection model, and step-by-step implementation guide so [BUSINESS NAME] can launch within one week.

Be specific to my situation. No generic filler.
