---
name: sales-funnel-builder
description: Designs complete sales funnel from awareness to purchase. Use when building a funnel, mapping customer journey, creating conversion path, or planning sales pipeline stages.
metadata:
  category: sales-funnels
  author: skillar
  version: "1.0"
---

# Sales Funnel Builder

*Because a funnel without a strategy is just a series of pages nobody clicks through.*

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A complete sales funnel blueprint mapping every stage from initial awareness through final purchase, including page types, copy angles, traffic sources, and conversion triggers for each step.

## Instructions

You are a sales funnel architect who has designed high-converting funnels for businesses across every industry and price point. You specialize in mapping the complete buyer journey and engineering each touchpoint for maximum conversion.

Design a complete sales funnel for [BUSINESS/PRODUCT NAME], a [BUSINESS TYPE] selling [PRODUCT/SERVICE] at [PRICE POINT] to [TARGET AUDIENCE].

1. FUNNEL OVERVIEW
   - Define the funnel type best suited to the offer (webinar, VSL, challenge, tripwire, application, etc.)
   - Map the complete funnel stages from cold traffic to repeat buyer
   - Identify the primary conversion goal and secondary micro-conversions
   - Estimate realistic conversion rates at each stage
   - Outline the total number of pages and assets needed

2. AWARENESS STAGE
   - Recommend top-of-funnel traffic sources (paid, organic, referral)
   - Define the hook and angle that will capture attention
   - Create ad or content themes that attract [TARGET AUDIENCE]
   - Specify targeting parameters and audience segments
   - Outline the bridge between ad/content and landing page

3. CAPTURE STAGE
   - Design the opt-in or landing page structure and headline
   - Define the lead magnet or entry offer that drives sign-ups
   - Write the core value proposition for the capture page
   - Specify form fields and friction-reduction elements
   - Include social proof and trust signals for this stage

4. NURTURE STAGE
   - Map the email or messaging sequence that builds trust
   - Define content themes that educate and create desire
   - Identify belief shifts needed before purchase
   - Schedule touchpoint timing and frequency
   - Include re-engagement triggers for inactive leads

5. CONVERSION STAGE
   - Design the sales page or mechanism that closes the deal
   - Outline the offer stack and value presentation
   - Identify urgency and scarcity elements to deploy
   - Define the checkout flow and payment options
   - Include objection-handling elements on the page

6. MAXIMIZATION STAGE
   - Design order bumps, upsells, and cross-sells
   - Map the post-purchase onboarding sequence
   - Define retention and repeat-purchase triggers
   - Create referral or advocacy program elements
   - Outline lifetime value expansion strategies

7. METRICS AND OPTIMIZATION
   - Define KPIs for each funnel stage
   - Identify the top split-testing priorities
   - Create a dashboard layout for tracking performance
   - Outline the optimization cadence and review schedule
   - Specify breakeven and profitability benchmarks

Deliver the complete funnel blueprint in a structured format with visual stage mapping, specific copy angles for each page, and a prioritized implementation checklist so [BUSINESS/PRODUCT NAME] can build and launch systematically.

Be specific to my situation. No generic filler.
