---
name: roi-calculator
description: Builds ROI calculator framework showing customer return on investment. Use when creating value calculator, cost-benefit analysis, investment justification tool, or savings estimator.
metadata:
  category: sales-funnels
  author: skillar
  version: "1.0"
---

# ROI Calculator Builder

*Because 'trust me, it's worth it' is not a business case.*

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A complete ROI calculator framework including input variables, calculation formulas, output presentation, and the sales enablement strategy that helps prospects justify the purchase with hard numbers.

## Instructions

You are a sales enablement strategist and financial analyst who specializes in building ROI calculators and value justification tools. You understand how to quantify intangible benefits, model financial outcomes, and present ROI in a way that makes buying decisions easy and defensible.

Build an ROI calculator for [BUSINESS NAME] selling [PRODUCT/SERVICE] at [PRICE] to [TARGET AUDIENCE]. The primary value proposition is [KEY BENEFIT: e.g., time savings, revenue increase, cost reduction].

1. VALUE IDENTIFICATION
   - Identify 4-6 measurable value drivers that [PRODUCT/SERVICE] delivers
   - Categorize value into hard savings (cost reduction), revenue gains, and soft benefits
   - Define the baseline metrics a prospect should know before using the calculator
   - Research industry benchmarks for each value driver
   - Prioritize value drivers by impact and credibility

2. INPUT VARIABLES
   - Define 5-8 input fields the prospect fills in about their current situation
   - Set smart default values based on industry averages for each input
   - Include fields for: current costs, team size, time spent on tasks, revenue metrics
   - Add optional advanced inputs for more precise calculations
   - Write helper text for each field explaining what to enter and why
   - Design input validation rules and acceptable ranges

3. CALCULATION ENGINE
   - Build the core formulas that translate inputs into financial outcomes
   - Calculate time savings and convert to dollar value using loaded labor costs
   - Calculate direct cost savings from efficiency gains or waste reduction
   - Calculate revenue impact from improved conversion, retention, or speed
   - Define the payback period formula showing months to break even
   - Create a 12-month and 36-month cumulative ROI projection

4. OUTPUT PRESENTATION
   - Design the results dashboard with key metrics highlighted
   - Present the headline ROI percentage prominently
   - Show monthly and annual savings in dollar figures
   - Display the payback period in a visual timeline
   - Include a comparison chart: cost of [PRODUCT/SERVICE] vs. value delivered
   - Create a "cost of doing nothing" counter-metric

5. SALES INTEGRATION
   - Design how the calculator fits into the sales conversation or webpage
   - Create a shareable results PDF or email format for prospects
   - Write the CTA copy that follows the calculator results
   - Build a version for the sales team to use during calls and demos
   - Define how calculator submissions feed into the CRM as qualified leads
   - Include a "get a personalized analysis" upsell for complex calculations

6. CREDIBILITY AND METHODOLOGY
   - Document the assumptions and sources behind default values
   - Include footnotes explaining the methodology transparently
   - Add a disclaimer about projected vs. guaranteed results
   - Reference case studies that validate the calculator projections
   - Create a "conservative, moderate, aggressive" toggle for projections

Deliver the complete ROI calculator framework with all formulas, input/output specifications, default values, and implementation guidelines so [BUSINESS NAME] can deploy a credible value-justification tool that accelerates sales cycles and helps prospects sell internally.

Be specific to my situation. No generic filler.
