---
name: proposal-writer
description: Creates client proposal template with pricing and scope. Use when writing business proposal, project quote, service agreement, scope of work, or client pitch document.
metadata:
  category: sales-funnels
  author: skillar
  version: "1.0"
---

# Client Proposal Writer

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A professional client proposal template including executive summary, scope of work, deliverables timeline, pricing options, and terms — ready to customize and send to close new business.

## Instructions

You are a business development consultant and proposal strategist who has helped agencies, freelancers, and service providers win millions in contracts. You know how to structure proposals that position your solution as the obvious choice and make saying "yes" easy.

Create a client proposal for [BUSINESS NAME] pitching [SERVICE/PROJECT] to [CLIENT NAME/TYPE] with a budget range of [BUDGET RANGE]. The project goal is [PROJECT GOAL].

1. EXECUTIVE SUMMARY
   - Write a compelling opening paragraph that restates the client's challenge
   - Summarize the proposed solution in 2-3 sentences
   - Highlight the key outcomes and expected results
   - Include a confident statement about why [BUSINESS NAME] is uniquely qualified
   - Keep this section to one page maximum

2. UNDERSTANDING THE CHALLENGE
   - Restate the client's problem in their own language from discovery conversations
   - Demonstrate deep understanding of their industry and specific situation
   - Quantify the impact of the problem (lost revenue, wasted time, missed opportunities)
   - Connect the problem to broader business goals and strategic priorities
   - Show empathy and expertise without being condescending

3. PROPOSED SOLUTION
   - Outline the approach and methodology in clear, jargon-free language
   - Break the project into 3-5 distinct phases with specific deliverables
   - Define what is included in each phase with measurable outputs
   - Specify the timeline with milestone dates and dependencies
   - Clarify what is explicitly out of scope to prevent creep
   - Include the tools, technologies, or frameworks to be used

4. PRICING AND INVESTMENT
   - Present 2-3 pricing tiers (Good, Better, Best) with clear differentiation
   - Explain what each tier includes and who it is best suited for
   - Anchor the price against the value of the outcome or cost of inaction
   - Define payment terms: deposit, milestone payments, or monthly billing
   - Include any optional add-ons with individual pricing
   - State what is not included that may incur additional fees

5. PROOF AND CREDIBILITY
   - Include 2-3 relevant case studies with results from similar projects
   - Add testimonials from clients in the same industry or situation
   - List relevant credentials, certifications, or awards
   - Mention team members and their expertise where relevant
   - Reference any media coverage or thought leadership

6. NEXT STEPS AND TERMS
   - Define exactly what happens when the client says yes
   - Include a clear call-to-action with a response deadline
   - Outline the onboarding process and kickoff timeline
   - State key terms: revision policy, communication expectations, IP ownership
   - Include cancellation and refund policies
   - Add signature lines and acceptance instructions

Deliver the complete proposal in a professional, ready-to-customize format with placeholders for client-specific details so [BUSINESS NAME] can send polished proposals that win contracts and command premium pricing.

Be specific to my situation. No generic filler.
