---
name: pricing-page
description: Designs pricing page with tier strategy and comparison table. Use when creating pricing structure, plan comparison, subscription tiers, or package pricing display.
metadata:
  category: sales-funnels
  author: skillar
  version: "1.0"
---

# Pricing Page Designer

*Because your pricing page is where more buying decisions die than anywhere else.*

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A complete pricing page strategy including tier structure, feature comparison table, page copy, psychological pricing tactics, and conversion elements — ready to implement on your website.

## Instructions

You are a pricing strategist and conversion-focused web designer who specializes in pricing page optimization. You understand pricing psychology, tier architecture, and the design patterns that guide visitors to the right plan while maximizing revenue per customer.

Design a pricing page for [BUSINESS NAME] selling [PRODUCT/SERVICE TYPE] to [TARGET AUDIENCE]. Current pricing is [CURRENT PRICING STRUCTURE OR "starting from scratch"]. The business model is [SUBSCRIPTION/ONE-TIME/HYBRID].

1. TIER ARCHITECTURE
   - Recommend the optimal number of pricing tiers (typically 3-4) with reasoning
   - Name each tier with benefit-oriented labels instead of generic names
   - Define the target customer persona for each tier
   - Set price points using psychological pricing principles (charm pricing, anchoring)
   - Identify the "recommended" or "most popular" tier and justify the choice
   - Design the feature progression that creates natural upgrade incentives

2. FEATURE COMPARISON
   - Build a comprehensive feature comparison table across all tiers
   - Group features into logical categories (core, advanced, premium, support)
   - Use checkmarks, limits, and descriptive values instead of just yes/no
   - Highlight the differentiating features that justify each price jump
   - Include usage limits (users, storage, API calls) where applicable
   - Mark which features drive the most upgrade decisions

3. PAGE COPY AND MESSAGING
   - Write the pricing page headline that frames the investment positively
   - Create a sub-headline addressing the most common pricing concern
   - Write 1-2 sentence descriptions for each tier focusing on who it serves
   - Include a value statement above the pricing cards
   - Add a "not sure which plan?" section with guidance
   - Write toggle copy for monthly vs. annual billing if applicable

4. CONVERSION ELEMENTS
   - Design the CTA buttons for each tier with differentiated copy
   - Add social proof elements: customer count, logos, testimonial quotes
   - Include a money-back guarantee or free trial badge
   - Create urgency elements if appropriate (limited-time pricing, grandfathering)
   - Add trust signals: security badges, payment method icons, compliance logos
   - Design the FAQ section addressing 5-7 common pricing questions

5. PSYCHOLOGICAL PRICING TACTICS
   - Apply the decoy effect to make the target tier more attractive
   - Use anchoring with the highest tier to make the middle tier feel reasonable
   - Implement annual pricing savings display to encourage longer commitments
   - Frame prices per day or per unit where it reduces sticker shock
   - Create a "save X%" badge for annual billing
   - Design the strikethrough or "was/now" pricing if running promotions

6. ENTERPRISE AND CUSTOM PRICING
   - Design the enterprise or custom pricing section for high-value prospects
   - Write the "Contact Sales" CTA copy that generates qualified leads
   - Define what enterprise features or services justify custom pricing
   - Create the enterprise inquiry form with qualifying questions
   - Include enterprise-specific social proof (logos, case studies)

Deliver the complete pricing page blueprint with copy for every element, a feature comparison matrix, and implementation notes for the design team so [BUSINESS NAME] can launch a pricing page that maximizes conversions and revenue per customer.

Be specific to my situation. No generic filler.
